% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_site_model_parameters_xml.R
\name{create_site_model_parameters_xml}
\alias{create_site_model_parameters_xml}
\title{Internal function to creates the XML text for the
\code{parameter}s within the \code{siteModel} section
of a BEAST2 parameter file.}
\usage{
create_site_model_parameters_xml(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
the site model as XML text
}
\description{
Internal function to creates the XML text for the
\code{parameter}s within the \code{siteModel} section,
which is part of the \code{siteModel} section
of a BEAST2 parameter file.
}
\details{
The \code{parameter}s sections has these elements:

\preformatted{
   [parameters]
}

\code{[parameters]} can be a combination of these:

\preformatted{
  <parameter id="mutationRate.s[...]>
  <parameter id="gammaShape.s[...]>
  <parameter id="proportionInvariant.s[...]>
}
}
\examples{
check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
