% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{plot_dd}
\alias{plot_dd}
\title{Plot Delay-Discounting Model}
\usage{
plot_dd(
  fit_dd_object,
  xlabel = "Delay",
  ylabel = "Indifference Point",
  title = "",
  logx = TRUE
)
}
\arguments{
\item{fit_dd_object}{A fitted delay-discounting model object of class \code{"fit_dd"}, created by the \code{fit_dd()} function.}

\item{xlabel}{A character string specifying the label for the x-axis. Default is \code{"Delay"}.}

\item{ylabel}{A character string specifying the label for the y-axis. Default is \code{"Indifference Point"}.}

\item{title}{A character string specifying the plot title. Default is \code{""}.}

\item{logx}{Logical. If \code{TRUE}, the x-axis is log-transformed. Default is \code{TRUE}.}
}
\value{
A ggplot object representing the fitted model and data.
}
\description{
This function generates a plot of the delay-discounting data and the fitted model.
}
\examples{
data <- data.frame(
  id = rep(1:2, each = 6),
  x = rep(c(1, 7, 30, 90, 180, 365), 2),
  y = c(0.9, 0.5, 0.3, 0.2, 0.1, 0.05, 0.85, 0.55, 0.35, 0.15, 0.1, 0.05)
)
fit <- fit_dd(data, equation = "mazur", method = "mean")
plot_dd(fit)
}
