// Generated by rstantools.  Do not edit by hand.

/*
    bellreg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bellreg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bellreg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_bellreg_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 157> locations_array__ =
  {" (found before start of program)",
  " (in 'bellreg', line 159, column 2 to column 21)",
  " (in 'bellreg', line 162, column 2 to column 17)",
  " (in 'bellreg', line 185, column 2 to column 40)",
  " (in 'bellreg', line 166, column 4 to column 43)",
  " (in 'bellreg', line 167, column 4 to column 58)",
  " (in 'bellreg', line 165, column 7 to line 168, column 3)",
  " (in 'bellreg', line 164, column 4 to column 34)",
  " (in 'bellreg', line 163, column 10 to line 165, column 3)",
  " (in 'bellreg', line 163, column 2 to line 168, column 3)",
  " (in 'bellreg', line 188, column 6 to column 49)",
  " (in 'bellreg', line 187, column 17 to line 189, column 5)",
  " (in 'bellreg', line 187, column 4 to line 189, column 5)",
  " (in 'bellreg', line 186, column 19 to line 190, column 3)",
  " (in 'bellreg', line 186, column 2 to line 190, column 3)",
  " (in 'bellreg', line 171, column 9 to column 10)",
  " (in 'bellreg', line 171, column 2 to column 28)",
  " (in 'bellreg', line 172, column 9 to column 10)",
  " (in 'bellreg', line 172, column 2 to column 40)",
  " (in 'bellreg', line 173, column 8 to column 9)",
  " (in 'bellreg', line 173, column 2 to column 22)",
  " (in 'bellreg', line 177, column 4 to column 33)",
  " (in 'bellreg', line 174, column 15 to line 178, column 3)",
  " (in 'bellreg', line 174, column 2 to line 178, column 3)",
  " (in 'bellreg', line 179, column 2 to column 34)",
  " (in 'bellreg', line 181, column 4 to column 43)",
  " (in 'bellreg', line 180, column 17 to line 182, column 3)",
  " (in 'bellreg', line 180, column 2 to line 182, column 3)",
  " (in 'bellreg', line 147, column 2 to column 17)",
  " (in 'bellreg', line 148, column 2 to column 17)",
  " (in 'bellreg', line 149, column 8 to column 9)",
  " (in 'bellreg', line 149, column 2 to column 17)",
  " (in 'bellreg', line 150, column 9 to column 10)",
  " (in 'bellreg', line 150, column 12 to column 13)",
  " (in 'bellreg', line 150, column 2 to column 17)",
  " (in 'bellreg', line 151, column 2 to column 33)",
  " (in 'bellreg', line 152, column 13 to column 14)",
  " (in 'bellreg', line 152, column 2 to column 23)",
  " (in 'bellreg', line 153, column 18 to column 19)",
  " (in 'bellreg', line 153, column 2 to column 26)",
  " (in 'bellreg', line 154, column 2 to column 33)",
  " (in 'bellreg', line 155, column 2 to column 15)",
  " (in 'bellreg', line 156, column 2 to column 27)",
  " (in 'bellreg', line 159, column 9 to column 10)",
  " (in 'bellreg', line 162, column 9 to column 10)",
  " (in 'bellreg', line 185, column 9 to column 30)",
  " (in 'bellreg', line 5, column 2 to column 27)",
  " (in 'bellreg', line 6, column 9 to column 10)",
  " (in 'bellreg', line 6, column 2 to column 14)",
  " (in 'bellreg', line 8, column 5 to column 30)",
  " (in 'bellreg', line 7, column 15 to line 9, column 3)",
  " (in 'bellreg', line 7, column 2 to line 9, column 3)",
  " (in 'bellreg', line 10, column 2 to column 12)",
  " (in 'bellreg', line 4, column 28 to line 11, column 1)",
  " (in 'bellreg', line 24, column 7 to column 30)",
  " (in 'bellreg', line 23, column 22 to column 41)",
  " (in 'bellreg', line 23, column 7 to line 24, column 30)",
  " (in 'bellreg', line 22, column 22 to column 32)",
  " (in 'bellreg', line 22, column 7 to line 24, column 30)",
  " (in 'bellreg', line 21, column 22 to column 37)",
  " (in 'bellreg', line 21, column 2 to line 24, column 30)",
  " (in 'bellreg', line 25, column 2 to column 12)",
  " (in 'bellreg', line 20, column 41 to line 26, column 1)",
  " (in 'bellreg', line 42, column 7 to column 30)",
  " (in 'bellreg', line 41, column 22 to column 52)",
  " (in 'bellreg', line 41, column 7 to line 42, column 30)",
  " (in 'bellreg', line 40, column 22 to column 46)",
  " (in 'bellreg', line 40, column 7 to line 42, column 30)",
  " (in 'bellreg', line 39, column 22 to column 38)",
  " (in 'bellreg', line 39, column 7 to line 42, column 30)",
  " (in 'bellreg', line 38, column 22 to column 45)",
  " (in 'bellreg', line 38, column 2 to line 42, column 30)",
  " (in 'bellreg', line 43, column 2 to column 12)",
  " (in 'bellreg', line 36, column 41 to line 44, column 1)",
  " (in 'bellreg', line 51, column 4 to column 11)",
  " (in 'bellreg', line 52, column 4 to column 11)",
  " (in 'bellreg', line 53, column 4 to column 28)",
  " (in 'bellreg', line 54, column 4 to column 73)",
  " (in 'bellreg', line 55, column 4 to column 37)",
  " (in 'bellreg', line 56, column 4 to column 37)",
  " (in 'bellreg', line 57, column 4 to column 37)",
  " (in 'bellreg', line 58, column 4 to column 14)",
  " (in 'bellreg', line 50, column 23 to line 59, column 3)",
  " (in 'bellreg', line 65, column 4 to column 10)",
  " (in 'bellreg', line 66, column 11 to column 12)",
  " (in 'bellreg', line 66, column 4 to column 16)",
  " (in 'bellreg', line 67, column 11 to column 12)",
  " (in 'bellreg', line 67, column 4 to column 19)",
  " (in 'bellreg', line 68, column 4 to column 13)",
  " (in 'bellreg', line 70, column 6 to column 12)",
  " (in 'bellreg', line 71, column 6 to column 21)",
  " (in 'bellreg', line 73, column 8 to column 41)",
  " (in 'bellreg', line 72, column 26 to line 74, column 7)",
  " (in 'bellreg', line 72, column 6 to line 74, column 7)",
  " (in 'bellreg', line 76, column 8 to column 23)",
  " (in 'bellreg', line 75, column 19 to line 77, column 7)",
  " (in 'bellreg', line 75, column 6 to line 77, column 7)",
  " (in 'bellreg', line 69, column 24 to line 78, column 5)",
  " (in 'bellreg', line 69, column 4 to line 78, column 5)",
  " (in 'bellreg', line 79, column 4 to column 24)",
  " (in 'bellreg', line 64, column 7 to line 80, column 3)",
  " (in 'bellreg', line 63, column 4 to column 14)",
  " (in 'bellreg', line 62, column 11 to line 64, column 3)",
  " (in 'bellreg', line 62, column 2 to line 80, column 3)",
  " (in 'bellreg', line 61, column 23 to line 81, column 1)",
  " (in 'bellreg', line 85, column 4 to column 12)",
  " (in 'bellreg', line 86, column 4 to column 15)",
  " (in 'bellreg', line 87, column 4 to column 23)",
  " (in 'bellreg', line 88, column 4 to column 66)",
  " (in 'bellreg', line 89, column 4 to column 17)",
  " (in 'bellreg', line 84, column 33 to line 90, column 3)",
  " (in 'bellreg', line 104, column 10 to column 25)",
  " (in 'bellreg', line 104, column 4 to column 38)",
  " (in 'bellreg', line 106, column 6 to column 52)",
  " (in 'bellreg', line 105, column 31 to line 107, column 5)",
  " (in 'bellreg', line 105, column 4 to line 107, column 5)",
  " (in 'bellreg', line 108, column 4 to column 22)",
  " (in 'bellreg', line 103, column 51 to line 109, column 3)",
  " (in 'bellreg', line 112, column 2 to column 26)",
  " (in 'bellreg', line 113, column 9 to column 10)",
  " (in 'bellreg', line 113, column 2 to column 18)",
  " (in 'bellreg', line 114, column 9 to column 10)",
  " (in 'bellreg', line 114, column 2 to column 24)",
  " (in 'bellreg', line 115, column 9 to column 10)",
  " (in 'bellreg', line 115, column 2 to column 40)",
  " (in 'bellreg', line 116, column 8 to column 9)",
  " (in 'bellreg', line 116, column 2 to column 22)",
  " (in 'bellreg', line 118, column 4 to column 33)",
  " (in 'bellreg', line 119, column 4 to column 42)",
  " (in 'bellreg', line 117, column 15 to line 120, column 3)",
  " (in 'bellreg', line 117, column 2 to line 120, column 3)",
  " (in 'bellreg', line 121, column 2 to column 15)",
  " (in 'bellreg', line 111, column 69 to line 122, column 1)",
  " (in 'bellreg', line 126, column 4 to column 28)",
  " (in 'bellreg', line 127, column 11 to column 12)",
  " (in 'bellreg', line 127, column 4 to column 20)",
  " (in 'bellreg', line 128, column 11 to column 12)",
  " (in 'bellreg', line 128, column 4 to column 26)",
  " (in 'bellreg', line 129, column 11 to column 12)",
  " (in 'bellreg', line 129, column 4 to column 27)",
  " (in 'bellreg', line 130, column 11 to column 12)",
  " (in 'bellreg', line 130, column 4 to column 44)",
  " (in 'bellreg', line 131, column 11 to column 12)",
  " (in 'bellreg', line 131, column 4 to column 47)",
  " (in 'bellreg', line 132, column 10 to column 11)",
  " (in 'bellreg', line 132, column 4 to column 24)",
  " (in 'bellreg', line 134, column 6 to column 35)",
  " (in 'bellreg', line 135, column 6 to column 35)",
  " (in 'bellreg', line 139, column 8 to column 77)",
  " (in 'bellreg', line 138, column 11 to line 140, column 7)",
  " (in 'bellreg', line 137, column 8 to column 120)",
  " (in 'bellreg', line 136, column 19 to line 138, column 7)",
  " (in 'bellreg', line 136, column 6 to line 140, column 7)",
  " (in 'bellreg', line 133, column 17 to line 141, column 5)",
  " (in 'bellreg', line 133, column 4 to line 141, column 5)",
  " (in 'bellreg', line 142, column 2 to column 15)",
  " (in 'bellreg', line 125, column 105 to line 143, column 1)"};
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
inv_logit2(const T0__& lp_arg__, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
linkinv_bell(const T0__& lp_arg__, const int& link, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
linkinv_bern(const T0__& lp_arg__, const int& link, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_stan_scalar<T0__>>* = nullptr>
stan::promote_args_t<T0__> lambertW(const T0__& x, std::ostream* pstream__);
double bellnumber(const int& n, std::ostream* pstream__);
template <bool propto__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T1__>>* = nullptr>
stan::promote_args_t<T1__>
bell_lpmf(const int& x, const T1__& theta, std::ostream* pstream__);
template <typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T1__>>* = nullptr>
stan::promote_args_t<T1__>
loglik_bell(const std::vector<int>& x, const std::vector<T1__>& theta,
            std::ostream* pstream__);
template <typename T1__, typename T2__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>>,-1,1>
loglik_bellreg(const std::vector<int>& y, const T1__& X_arg__, const T2__&
               beta_arg__, const int& link, std::ostream* pstream__);
template <typename T1__, typename T2__, typename T3__, typename T4__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_eigen_matrix_dynamic<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_col_vector<T3__>,
                              stan::is_vt_not_complex<T3__>,
                              stan::is_col_vector<T4__>,
                              stan::is_vt_not_complex<T4__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>, stan::base_type_t<T3__>,
                stan::base_type_t<T4__>>,-1,1>
loglik_zibellreg(const std::vector<int>& y, const T1__& X_arg__, const T2__&
                 Z_arg__, const T3__& beta_arg__, const T4__& psi_arg__,
                 const int& link1, const int& link2, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
inv_logit2(const T0__& lp_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& lp = stan::math::to_ref(lp_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n = std::numeric_limits<int>::min();
    current_statement__ = 46;
    n = stan::math::num_elements(lp);
    current_statement__ = 47;
    stan::math::validate_non_negative_index("x", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> x =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 51;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 49;
      stan::model::assign(x, (1 / (1 +
        stan::math::exp(
          -stan::model::rvalue(lp, "lp", stan::model::index_uni(i))))),
        "assigning variable x", stan::model::index_uni(i));
    }
    current_statement__ = 52;
    return x;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
linkinv_bell(const T0__& lp_arg__, const int& link, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& lp = stan::math::to_ref(lp_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 60;
    if (stan::math::logical_eq(link, 1)) {
      current_statement__ = 59;
      return stan::math::exp(lp);
    } else {
      current_statement__ = 58;
      if (stan::math::logical_eq(link, 2)) {
        current_statement__ = 57;
        return lp;
      } else {
        current_statement__ = 56;
        if (stan::math::logical_eq(link, 3)) {
          current_statement__ = 55;
          return stan::math::square(lp);
        } else {
          current_statement__ = 54;
          std::stringstream errmsg_stream__;
          stan::math::stan_print(&errmsg_stream__, "Invalid link");
          throw std::domain_error(errmsg_stream__.str());
        }
      }
    }
    current_statement__ = 61;
    return lp;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
linkinv_bern(const T0__& lp_arg__, const int& link, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& lp = stan::math::to_ref(lp_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 71;
    if (stan::math::logical_eq(link, 1)) {
      current_statement__ = 70;
      return inv_logit2(lp, pstream__);
    } else {
      current_statement__ = 69;
      if (stan::math::logical_eq(link, 2)) {
        current_statement__ = 68;
        return stan::math::Phi(lp);
      } else {
        current_statement__ = 67;
        if (stan::math::logical_eq(link, 3)) {
          current_statement__ = 66;
          return stan::math::inv_cloglog(lp);
        } else {
          current_statement__ = 65;
          if (stan::math::logical_eq(link, 4)) {
            current_statement__ = 64;
            return stan::math::add(
                     stan::math::divide(stan::math::atan(lp),
                       stan::math::pi()), 0.5);
          } else {
            current_statement__ = 63;
            std::stringstream errmsg_stream__;
            stan::math::stan_print(&errmsg_stream__, "Invalid link");
            throw std::domain_error(errmsg_stream__.str());
          }
        }
      }
    }
    current_statement__ = 72;
    return lp;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, stan::require_all_t<stan::is_stan_scalar<T0__>>*>
stan::promote_args_t<T0__> lambertW(const T0__& x, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ y = DUMMY_VAR__;
    local_scalar_t__ w = DUMMY_VAR__;
    current_statement__ = 76;
    y = stan::math::sqrt((1 + (stan::math::exp(1) * x)));
    current_statement__ = 77;
    w = (-1 + (2.036 *
      stan::math::log(((1 + (1.14956131 * y)) / (1 + (0.45495740 *
        stan::math::log((1 + y))))))));
    current_statement__ = 78;
    w = ((w / (1 + w)) * (1 + stan::math::log((x / w))));
    current_statement__ = 79;
    w = ((w / (1 + w)) * (1 + stan::math::log((x / w))));
    current_statement__ = 80;
    w = ((w / (1 + w)) * (1 + stan::math::log((x / w))));
    current_statement__ = 81;
    return w;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
double bellnumber(const int& n, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 103;
    if (stan::math::logical_lt(n, 2)) {
      current_statement__ = 101;
      return 1;
    } else {
      int k = std::numeric_limits<int>::min();
      current_statement__ = 84;
      stan::math::validate_non_negative_index("B", "n", n);
      Eigen::Matrix<local_scalar_t__,-1,1> B =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 86;
      stan::math::validate_non_negative_index("Bneu", "n", n);
      Eigen::Matrix<local_scalar_t__,-1,1> Bneu =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 88;
      stan::model::assign(B, 1, "assigning variable B",
        stan::model::index_uni(1));
      current_statement__ = 98;
      for (int i = 1; i <= (n - 1); ++i) {
        current_statement__ = 89;
        k = i;
        current_statement__ = 90;
        stan::model::assign(Bneu,
          stan::model::rvalue(B, "B", stan::model::index_uni(i)),
          "assigning variable Bneu", stan::model::index_uni(1));
        current_statement__ = 93;
        for (int j = 2; j <= (i + 1); ++j) {
          current_statement__ = 91;
          stan::model::assign(Bneu,
            (stan::model::rvalue(B, "B", stan::model::index_uni((j - 1))) +
            stan::model::rvalue(Bneu, "Bneu", stan::model::index_uni((j - 1)))),
            "assigning variable Bneu", stan::model::index_uni(j));
        }
        current_statement__ = 96;
        for (int j = 1; j <= n; ++j) {
          current_statement__ = 94;
          stan::model::assign(B,
            stan::model::rvalue(Bneu, "Bneu", stan::model::index_uni(j)),
            "assigning variable B", stan::model::index_uni(j));
        }
      }
      current_statement__ = 99;
      return stan::model::rvalue(Bneu, "Bneu",
               stan::model::index_uni((k + 1)));
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T1__>>*>
stan::promote_args_t<T1__>
bell_lpmf(const int& x, const T1__& theta, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T1__>;
  int current_statement__ = 0;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ Bx = DUMMY_VAR__;
    local_scalar_t__ lprob = DUMMY_VAR__;
    current_statement__ = 107;
    Bx = bellnumber(x, pstream__);
    current_statement__ = 108;
    lprob = (((((x * stan::math::log(theta)) - stan::math::exp(theta)) + 1) +
      stan::math::log(Bx)) - stan::math::lgamma((x + 1)));
    current_statement__ = 109;
    return lprob;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T1__, stan::require_all_t<stan::is_stan_scalar<T1__>>*>
stan::promote_args_t<T1__>
loglik_bell(const std::vector<int>& x, const std::vector<T1__>& theta,
            std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T1__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 111;
    stan::math::validate_non_negative_index("lprob", "num_elements(x)",
      stan::math::num_elements(x));
    std::vector<local_scalar_t__> lprob =
      std::vector<local_scalar_t__>(stan::math::num_elements(x), DUMMY_VAR__);
    current_statement__ = 115;
    for (int i = 1; i <= stan::math::num_elements(x); ++i) {
      current_statement__ = 113;
      stan::model::assign(lprob,
        ((stan::model::rvalue(x, "x", stan::model::index_uni(i)) *
        stan::math::log(
          stan::model::rvalue(theta, "theta", stan::model::index_uni(i)))) -
        stan::math::exp(
          stan::model::rvalue(theta, "theta", stan::model::index_uni(i)))),
        "assigning variable lprob", stan::model::index_uni(i));
    }
    current_statement__ = 116;
    return stan::math::sum(lprob);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T1__, typename T2__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>>,-1,1>
loglik_bellreg(const std::vector<int>& y, const T1__& X_arg__, const T2__&
               beta_arg__, const int& link, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T1__>,
                             stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& X = stan::math::to_ref(X_arg__);
  const auto& beta = stan::math::to_ref(beta_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n = std::numeric_limits<int>::min();
    current_statement__ = 118;
    n = stan::math::num_elements(y);
    current_statement__ = 119;
    stan::math::validate_non_negative_index("lprob", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lprob =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 121;
    stan::math::validate_non_negative_index("lp", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lp =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 122;
    stan::model::assign(lp, stan::math::multiply(X, beta),
      "assigning variable lp");
    current_statement__ = 123;
    stan::math::validate_non_negative_index("mu", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> mu =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 124;
    stan::model::assign(mu, linkinv_bell(lp, link, pstream__),
      "assigning variable mu");
    current_statement__ = 125;
    stan::math::validate_non_negative_index("theta", "n", n);
    std::vector<local_scalar_t__> theta =
      std::vector<local_scalar_t__>(n, DUMMY_VAR__);
    current_statement__ = 130;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 127;
      stan::model::assign(theta,
        stan::math::lambert_w0(
          stan::model::rvalue(mu, "mu", stan::model::index_uni(i))),
        "assigning variable theta", stan::model::index_uni(i));
      current_statement__ = 128;
      stan::model::assign(lprob,
        bell_lpmf<false>(
          stan::model::rvalue(y, "y", stan::model::index_uni(i)),
          stan::model::rvalue(theta, "theta", stan::model::index_uni(i)),
          pstream__), "assigning variable lprob", stan::model::index_uni(i));
    }
    current_statement__ = 131;
    return lprob;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T1__, typename T2__, typename T3__, typename T4__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_eigen_matrix_dynamic<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_col_vector<T3__>,
                              stan::is_vt_not_complex<T3__>,
                              stan::is_col_vector<T4__>,
                              stan::is_vt_not_complex<T4__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>, stan::base_type_t<T3__>,
                stan::base_type_t<T4__>>,-1,1>
loglik_zibellreg(const std::vector<int>& y, const T1__& X_arg__, const T2__&
                 Z_arg__, const T3__& beta_arg__, const T4__& psi_arg__,
                 const int& link1, const int& link2, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T1__>,
                             stan::base_type_t<T2__>,
                             stan::base_type_t<T3__>,
                             stan::base_type_t<T4__>>;
  int current_statement__ = 0;
  const auto& X = stan::math::to_ref(X_arg__);
  const auto& Z = stan::math::to_ref(Z_arg__);
  const auto& beta = stan::math::to_ref(beta_arg__);
  const auto& psi = stan::math::to_ref(psi_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n = std::numeric_limits<int>::min();
    current_statement__ = 133;
    n = stan::math::num_elements(y);
    current_statement__ = 134;
    stan::math::validate_non_negative_index("lprob", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lprob =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 136;
    stan::math::validate_non_negative_index("lp1", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lp1 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 137;
    stan::model::assign(lp1, stan::math::multiply(Z, psi),
      "assigning variable lp1");
    current_statement__ = 138;
    stan::math::validate_non_negative_index("lp2", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lp2 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 139;
    stan::model::assign(lp2, stan::math::multiply(X, beta),
      "assigning variable lp2");
    current_statement__ = 140;
    stan::math::validate_non_negative_index("mu", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> mu =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 141;
    stan::model::assign(mu, linkinv_bell(lp2, link2, pstream__),
      "assigning variable mu");
    current_statement__ = 142;
    stan::math::validate_non_negative_index("omega", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> omega =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 143;
    stan::model::assign(omega, linkinv_bern(lp1, link1, pstream__),
      "assigning variable omega");
    current_statement__ = 144;
    stan::math::validate_non_negative_index("theta", "n", n);
    std::vector<local_scalar_t__> theta =
      std::vector<local_scalar_t__>(n, DUMMY_VAR__);
    current_statement__ = 154;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 146;
      stan::model::assign(omega,
        stan::math::inv_logit(
          stan::model::rvalue(lp1, "lp1", stan::model::index_uni(i))),
        "assigning variable omega", stan::model::index_uni(i));
      current_statement__ = 147;
      stan::model::assign(theta,
        stan::math::lambert_w0(
          stan::model::rvalue(mu, "mu", stan::model::index_uni(i))),
        "assigning variable theta", stan::model::index_uni(i));
      current_statement__ = 152;
      if (stan::math::logical_eq(
            stan::model::rvalue(y, "y", stan::model::index_uni(i)), 0)) {
        current_statement__ = 150;
        stan::model::assign(lprob,
          stan::math::log_sum_exp(
            stan::math::bernoulli_lpmf<false>(1,
              stan::model::rvalue(omega, "omega", stan::model::index_uni(i))),
            (stan::math::bernoulli_lpmf<false>(0,
               stan::model::rvalue(omega, "omega", stan::model::index_uni(i)))
            +
            bell_lpmf<false>(
              stan::model::rvalue(y, "y", stan::model::index_uni(i)),
              stan::model::rvalue(theta, "theta", stan::model::index_uni(i)),
              pstream__))), "assigning variable lprob",
          stan::model::index_uni(i));
      } else {
        current_statement__ = 148;
        stan::model::assign(lprob,
          (stan::math::bernoulli_lpmf<false>(0,
             stan::model::rvalue(omega, "omega", stan::model::index_uni(i)))
          +
          bell_lpmf<false>(
            stan::model::rvalue(y, "y", stan::model::index_uni(i)),
            stan::model::rvalue(theta, "theta", stan::model::index_uni(i)),
            pstream__)), "assigning variable lprob",
          stan::model::index_uni(i));
      }
    }
    current_statement__ = 155;
    return lprob;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_bellreg final : public model_base_crtp<model_bellreg> {
private:
  int n;
  int p;
  std::vector<int> y;
  Eigen::Matrix<double,-1,-1> X_data__;
  int link;
  Eigen::Matrix<double,1,-1> x_mean_data__;
  Eigen::Matrix<double,-1,1> x_sd_data__;
  int approach;
  double mu_beta;
  double sigma_beta;
  int log_lik_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,1,-1>> x_mean{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> x_sd{nullptr, 0};
public:
  ~model_bellreg() {}
  model_bellreg(stan::io::var_context& context__, unsigned int
                random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_bellreg_namespace::model_bellreg";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 28;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 28;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 28;
      stan::math::check_greater_or_equal(function__, "n", n, 1);
      current_statement__ = 29;
      context__.validate_dims("data initialization", "p", "int",
        std::vector<size_t>{});
      p = std::numeric_limits<int>::min();
      current_statement__ = 29;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 29;
      stan::math::check_greater_or_equal(function__, "p", p, 1);
      current_statement__ = 30;
      stan::math::validate_non_negative_index("y", "n", n);
      current_statement__ = 31;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(n)});
      y = std::vector<int>(n, std::numeric_limits<int>::min());
      current_statement__ = 31;
      y = context__.vals_i("y");
      current_statement__ = 32;
      stan::math::validate_non_negative_index("X", "n", n);
      current_statement__ = 33;
      stan::math::validate_non_negative_index("X", "p", p);
      current_statement__ = 34;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(n), static_cast<size_t>(p)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(n, p,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), n, p);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 34;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 34;
        pos__ = 1;
        current_statement__ = 34;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 34;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 34;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 34;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 35;
      context__.validate_dims("data initialization", "link", "int",
        std::vector<size_t>{});
      link = std::numeric_limits<int>::min();
      current_statement__ = 35;
      link = context__.vals_i("link")[(1 - 1)];
      current_statement__ = 35;
      stan::math::check_greater_or_equal(function__, "link", link, 1);
      current_statement__ = 35;
      stan::math::check_less_or_equal(function__, "link", link, 3);
      current_statement__ = 36;
      stan::math::validate_non_negative_index("x_mean", "p", p);
      current_statement__ = 37;
      context__.validate_dims("data initialization", "x_mean", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      x_mean_data__ = Eigen::Matrix<double,1,-1>::Constant(p,
                        std::numeric_limits<double>::quiet_NaN());
      new (&x_mean)
        Eigen::Map<Eigen::Matrix<double,1,-1>>(x_mean_data__.data(), p);
      {
        std::vector<local_scalar_t__> x_mean_flat__;
        current_statement__ = 37;
        x_mean_flat__ = context__.vals_r("x_mean");
        current_statement__ = 37;
        pos__ = 1;
        current_statement__ = 37;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 37;
          stan::model::assign(x_mean, x_mean_flat__[(pos__ - 1)],
            "assigning variable x_mean", stan::model::index_uni(sym1__));
          current_statement__ = 37;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 38;
      stan::math::validate_non_negative_index("x_sd", "p", p);
      current_statement__ = 39;
      context__.validate_dims("data initialization", "x_sd", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      x_sd_data__ = Eigen::Matrix<double,-1,1>::Constant(p,
                      std::numeric_limits<double>::quiet_NaN());
      new (&x_sd) Eigen::Map<Eigen::Matrix<double,-1,1>>(x_sd_data__.data(),
        p);
      {
        std::vector<local_scalar_t__> x_sd_flat__;
        current_statement__ = 39;
        x_sd_flat__ = context__.vals_r("x_sd");
        current_statement__ = 39;
        pos__ = 1;
        current_statement__ = 39;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 39;
          stan::model::assign(x_sd, x_sd_flat__[(pos__ - 1)],
            "assigning variable x_sd", stan::model::index_uni(sym1__));
          current_statement__ = 39;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 39;
      stan::math::check_greater_or_equal(function__, "x_sd", x_sd, 0);
      current_statement__ = 40;
      context__.validate_dims("data initialization", "approach", "int",
        std::vector<size_t>{});
      approach = std::numeric_limits<int>::min();
      current_statement__ = 40;
      approach = context__.vals_i("approach")[(1 - 1)];
      current_statement__ = 40;
      stan::math::check_greater_or_equal(function__, "approach", approach, 0);
      current_statement__ = 40;
      stan::math::check_less_or_equal(function__, "approach", approach, 1);
      current_statement__ = 41;
      context__.validate_dims("data initialization", "mu_beta", "double",
        std::vector<size_t>{});
      mu_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 41;
      mu_beta = context__.vals_r("mu_beta")[(1 - 1)];
      current_statement__ = 42;
      context__.validate_dims("data initialization", "sigma_beta", "double",
        std::vector<size_t>{});
      sigma_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 42;
      sigma_beta = context__.vals_r("sigma_beta")[(1 - 1)];
      current_statement__ = 42;
      stan::math::check_greater_or_equal(function__, "sigma_beta",
        sigma_beta, 0);
      current_statement__ = 43;
      stan::math::validate_non_negative_index("beta_std", "p", p);
      current_statement__ = 44;
      stan::math::validate_non_negative_index("beta", "p", p);
      current_statement__ = 45;
      log_lik_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 45;
      log_lik_1dim__ = (stan::math::logical_eq(approach, 1) ? n : 0);
      current_statement__ = 45;
      stan::math::validate_non_negative_index("log_lik",
        "approach == 1 ? n : 0", log_lik_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = p;
  }
  inline std::string model_name() const final {
    return "model_bellreg";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_bellreg_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> beta_std =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 1;
      beta_std = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 9;
      if (stan::math::logical_eq(p, 1)) {
        current_statement__ = 7;
        stan::model::assign(beta,
          (stan::model::rvalue(beta_std, "beta_std",
             stan::model::index_uni(1)) /
          stan::model::rvalue(x_sd, "x_sd", stan::model::index_uni(1))),
          "assigning variable beta", stan::model::index_uni(1));
      } else {
        current_statement__ = 4;
        stan::model::assign(beta,
          stan::math::elt_divide(
            stan::model::rvalue(beta_std, "beta_std",
              stan::model::index_min_max(2, p)),
            stan::model::rvalue(x_sd, "x_sd",
              stan::model::index_min_max(2, p))), "assigning variable beta",
          stan::model::index_min_max(2, p));
        current_statement__ = 5;
        stan::model::assign(beta,
          ((stan::model::rvalue(beta_std, "beta_std",
              stan::model::index_uni(1)) /
          stan::model::rvalue(x_sd, "x_sd", stan::model::index_uni(1))) -
          stan::math::multiply(
            stan::model::rvalue(x_mean, "x_mean",
              stan::model::index_min_max(2, p)),
            stan::model::rvalue(beta, "beta",
              stan::model::index_min_max(2, p)))), "assigning variable beta",
          stan::model::index_uni(1));
      }
      {
        current_statement__ = 15;
        stan::math::validate_non_negative_index("lp", "n", n);
        Eigen::Matrix<local_scalar_t__,-1,1> lp =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
        current_statement__ = 16;
        stan::model::assign(lp, stan::math::multiply(X, beta_std),
          "assigning variable lp");
        current_statement__ = 17;
        stan::math::validate_non_negative_index("mu", "n", n);
        Eigen::Matrix<local_scalar_t__,-1,1> mu =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
        current_statement__ = 18;
        stan::model::assign(mu, linkinv_bell(lp, link, pstream__),
          "assigning variable mu");
        current_statement__ = 19;
        stan::math::validate_non_negative_index("theta", "n", n);
        std::vector<local_scalar_t__> theta =
          std::vector<local_scalar_t__>(n, DUMMY_VAR__);
        current_statement__ = 23;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 21;
          stan::model::assign(theta,
            stan::math::lambert_w0(
              stan::model::rvalue(mu, "mu", stan::model::index_uni(i))),
            "assigning variable theta", stan::model::index_uni(i));
        }
        current_statement__ = 24;
        lp_accum__.add(loglik_bell(y, theta, pstream__));
        current_statement__ = 27;
        if (stan::math::logical_eq(approach, 1)) {
          current_statement__ = 25;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(beta_std, mu_beta,
                           sigma_beta));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_bellreg_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> beta_std =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      beta_std = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(beta_std);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 9;
      if (stan::math::logical_eq(p, 1)) {
        current_statement__ = 7;
        stan::model::assign(beta,
          (stan::model::rvalue(beta_std, "beta_std",
             stan::model::index_uni(1)) /
          stan::model::rvalue(x_sd, "x_sd", stan::model::index_uni(1))),
          "assigning variable beta", stan::model::index_uni(1));
      } else {
        current_statement__ = 4;
        stan::model::assign(beta,
          stan::math::elt_divide(
            stan::model::rvalue(beta_std, "beta_std",
              stan::model::index_min_max(2, p)),
            stan::model::rvalue(x_sd, "x_sd",
              stan::model::index_min_max(2, p))), "assigning variable beta",
          stan::model::index_min_max(2, p));
        current_statement__ = 5;
        stan::model::assign(beta,
          ((stan::model::rvalue(beta_std, "beta_std",
              stan::model::index_uni(1)) /
          stan::model::rvalue(x_sd, "x_sd", stan::model::index_uni(1))) -
          stan::math::multiply(
            stan::model::rvalue(x_mean, "x_mean",
              stan::model::index_min_max(2, p)),
            stan::model::rvalue(beta, "beta",
              stan::model::index_min_max(2, p)))), "assigning variable beta",
          stan::model::index_uni(1));
      }
      if (emit_transformed_parameters__) {
        out__.write(beta);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(log_lik_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 14;
      if (stan::math::logical_eq(approach, 1)) {
        current_statement__ = 12;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 10;
          stan::model::assign(log_lik,
            loglik_bellreg(y, X, beta, link, pstream__),
            "assigning variable log_lik");
        }
      }
      out__.write(log_lik);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> beta_std =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(beta_std,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(p),
        "assigning variable beta_std");
      out__.write(beta_std);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "beta_std",
        "double", std::vector<size_t>{static_cast<size_t>(p)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> beta_std =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_std_flat__;
        current_statement__ = 1;
        beta_std_flat__ = context__.vals_r("beta_std");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(beta_std, beta_std_flat__[(pos__ - 1)],
            "assigning variable beta_std", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta_std);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"beta_std"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"beta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"log_lik"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(p)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(p)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(log_lik_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_std" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_std" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta_std\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(log_lik_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta_std\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(log_lik_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = p;
    const size_t num_transformed = emit_transformed_parameters * (p);
    const size_t num_gen_quantities = emit_generated_quantities *
      (log_lik_1dim__);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = p;
    const size_t num_transformed = emit_transformed_parameters * (p);
    const size_t num_gen_quantities = emit_generated_quantities *
      (log_lik_1dim__);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_bellreg_namespace::model_bellreg;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_bellreg_namespace::profiles__;
}
#endif
#endif
