% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{hurlbert}
\alias{hurlbert}
\alias{hurlbert_}
\title{Hurlbert's Expected Number of Species}
\usage{
hurlbert(.data = NULL, taxon, count, n = 100L)

hurlbert_(.data = NULL, taxon, count, n = 100L)
}
\arguments{
\item{.data}{data in a \code{data.frame}, \code{tibble}, 
\code{data.table}, database etc.}

\item{taxon}{name of column in \code{.data} containing taxa}

\item{count}{name of column in \code{.data} containing counts}

\item{n}{number of individuals in a standard sample}
}
\value{
expected number of species in a sample of \code{n} individuals
}
\description{
The expected number of species in a sample of \code{n} individuals:
}
\section{Functions}{
\itemize{
\item \code{hurlbert_()}: version suitable for calling from a function
(see package \pkg{lazyeval}).

}}
\examples{
     hurlbert(
         taxon = c("Euspira pulchella", "Nephtys cirrosa"), 
         count = c(4, 6),
         n = 8
     )
     
}
\references{
Hurlbert, S.H., 1971. The Nonconcept of Species Diversity: 
     A Critique and Alternative Parameters. Ecology 52:577-586.
}
