% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortDF.R
\name{sortDF}
\alias{sortDF}
\title{sort dataframes by column}
\usage{
sortDF(df, col, decreasing = TRUE, quiet = FALSE, ...)
}
\arguments{
\item{df}{Data.frame to be sorted}

\item{col}{Column (index or (un)quoted name) to be sorted by}

\item{decreasing}{Logical: should highest value be on top?
DEFAULT: TRUE (unlike \code{\link{order}}!)}

\item{quiet}{Logical: suppress non-df warning? DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{\link{order}}, 
like eg \code{na.last or method}}
}
\value{
data.frame
}
\description{
sort a data.frame by column - basically just a wrapper for order
}
\examples{
sortDF(USArrests[USArrests$Murder>11,], Assault)
sortDF(USArrests[USArrests$Murder>11,], "Assault") # safer within functions
sortDF(USArrests[USArrests$Murder>11,], 3)

}
\seealso{
\code{\link{sort}}, \code{\link{order}}, 
\code{\link{insertRows}}, \code{\link{addRows}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, June 2015
}
\keyword{arith}
\keyword{manip}
\keyword{univar}
