% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.bsrr.R
\name{predict.bsrr}
\alias{predict.bsrr}
\title{make predictions from a "bsrr" object.}
\usage{
\method{predict}{bsrr}(object, newx, type = c("link", "response"), ...)
}
\arguments{
\item{object}{Output from the \code{bsrr} function.}

\item{newx}{New data used for prediction. If omitted, the fitted linear predictors are used.}

\item{type}{\code{type = "link"} gives the linear predictors for \code{"binomial"},
\code{"poisson"} or \code{"cox"} models; for \code{"gaussian"} models it gives the
fitted values. \code{type = "response"} gives the fitted probabilities for
\code{"binomial"}, fitted mean for \code{"poisson"} and the fitted relative-risk for
\code{"cox"}; for \code{"gaussian"}, \code{type = "response"} is equivalent to \code{type = "link"}}

\item{\dots}{Additional arguments affecting the predictions produced.}
}
\value{
The object returned depends on the types of family.
}
\description{
Returns predictions from a fitted
"\code{bsrr}" object.
}
\examples{

#-------------------linear model----------------------#
# Generate simulated data
n <- 200
p <- 20
k <- 5
rho <- 0.4
seed <- 10
Tbeta <- rep(0, p)
Tbeta[1:k*floor(p/k):floor(p/k)] <- rep(1, k)
Data <- gen.data(n, p, k, rho, family = "gaussian", beta = Tbeta, seed = seed)
x <- Data$x[1:140, ]
y <- Data$y[1:140]
x_new <- Data$x[141:200, ]
y_new <- Data$y[141:200]
lambda.list <- exp(seq(log(5), log(0.1), length.out = 10))
lm.bsrr <- bsrr(x, y, method = "pgsection")

pred.bsrr <- predict(lm.bsrr, newx = x_new)

#-------------------logistic model----------------------#
#Generate simulated data
Data <- gen.data(n, p, k, rho, family = "binomial", beta = Tbeta, seed = seed)

x <- Data$x[1:140, ]
y <- Data$y[1:140]
x_new <- Data$x[141:200, ]
y_new <- Data$y[141:200]
lambda.list <- exp(seq(log(5), log(0.1), length.out = 10))
logi.bsrr <- bsrr(x, y, tune="cv",
                 family = "binomial", lambda.list = lambda.list, method = "sequential")

pred.bsrr <- predict(logi.bsrr, newx = x_new)

#-------------------coxph model----------------------#
#Generate simulated data
Data <- gen.data(n, p, k, rho, family = "cox", beta = Tbeta, scal = 10)

x <- Data$x[1:140, ]
y <- Data$y[1:140, ]
x_new <- Data$x[141:200, ]
y_new <- Data$y[141:200, ]
lambda.list <- exp(seq(log(5), log(0.1), length.out = 10))
cox.bsrr <- bsrr(x, y, family = "cox", lambda.list = lambda.list)

pred.bsrr <- predict(cox.bsrr, newx = x_new)

#-------------------group selection----------------------#
beta <- rep(c(rep(1,2),rep(0,3)), 4)
Data <- gen.data(200, 20, 5, rho=0.4, beta = beta, seed =10)
x <- Data$x
y <- Data$y

group.index <- c(rep(1, 2), rep(2, 3), rep(3, 2), rep(4, 3),
                rep(5, 2), rep(6, 3), rep(7, 2), rep(8, 3))
lm.groupbsrr <- bsrr(x, y, s.min = 1, s.max = 8, group.index = group.index)

pred.groupbsrr <- predict(lm.groupbsrr, newx = x_new)

}
\seealso{
\code{\link{bsrr}}.
}
\author{
Liyuan Hu, Kangkang Jiang, Yanhang Zhang, Jin Zhu, Canhong Wen and Xueqin Wang.
}
