% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-mc.R
\name{MC}
\alias{MC}
\title{Generate the Sampling Distribution of Regression Parameters
Using the Monte Carlo Method}
\usage{
MC(
  object,
  R = 20000L,
  type = "hc3",
  g1 = 1,
  g2 = 1.5,
  k = 0.7,
  decomposition = "eigen",
  pd = TRUE,
  tol = 1e-06,
  fixed_x = FALSE,
  seed = NULL
)
}
\arguments{
\item{object}{Object of class \code{lm}.}

\item{R}{Positive integer.
Number of Monte Carlo replications.}

\item{type}{Character string.
Sampling covariance matrix type.
Possible values are
\code{"mvn"},
\code{"adf"},
\code{"hc0"},
\code{"hc1"},
\code{"hc2"},
\code{"hc3"},
\code{"hc4"},
\code{"hc4m"}, and
\code{"hc5"}.
\code{type = "mvn"} uses the normal-theory sampling covariance matrix.
\code{type = "adf"} uses the asymptotic distribution-free
sampling covariance matrix.
\code{type = "hc0"} through \code{"hc5"} uses different versions of
heteroskedasticity-consistent sampling covariance matrix.}

\item{g1}{Numeric.
\code{g1} value for \code{type = "hc4m"}.}

\item{g2}{Numeric.
\code{g2} value for \code{type = "hc4m"}.}

\item{k}{Numeric.
Constant for \code{type = "hc5"}}

\item{decomposition}{Character string.
Matrix decomposition of the sampling variance-covariance matrix
for the data generation.
If \code{decomposition = "chol"}, use Cholesky decomposition.
If \code{decomposition = "eigen"}, use eigenvalue decomposition.
If \code{decomposition = "svd"}, use singular value decomposition.}

\item{pd}{Logical.
If \code{pd = TRUE},
check if the sampling variance-covariance matrix
is positive definite using \code{tol}.}

\item{tol}{Numeric.
Tolerance used for \code{pd}.}

\item{fixed_x}{Logical.
If \code{fixed_x = TRUE}, treat the regressors as fixed.
If \code{fixed_x = FALSE}, treat the regressors as random.}

\item{seed}{Integer.
Seed number for reproducibility.}
}
\value{
Returns an object
of class \code{mc} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{lm_process}{Processed \code{lm} object.}
\item{scale}{Sampling variance-covariance matrix of parameter estimates.}
\item{location}{Parameter estimates.}
\item{thetahatstar}{Sampling distribution of parameter estimates.}
\item{fun}{Function used ("MC").}
}
}
\description{
Generate the Sampling Distribution of Regression Parameters
Using the Monte Carlo Method
}
\details{
Let the parameter vector
of the unstandardized regression model be given by
\deqn{
    \boldsymbol{\theta}
    =
    \left\{
    \mathbf{b},
    \sigma^{2},
    \mathrm{vech}
    \left(
      \boldsymbol{\Sigma}_{\mathbf{X}\mathbf{X}}
    \right)
    \right\}
  }
where \eqn{\mathbf{b}} is the vector of regression slopes,
\eqn{\sigma^{2}} is the error variance,
and
\eqn{
    \mathrm{vech}
    \left(
      \boldsymbol{\Sigma}_{\mathbf{X}\mathbf{X}}
    \right)
  }
is the vector of unique elements
of the covariance matrix of the regressor variables.
The empirical sampling distribution
of \eqn{\boldsymbol{\theta}}
is generated using the Monte Carlo method,
that is, random values of parameter estimates
are sampled from the multivariate normal distribution
using the estimated parameter vector as the mean vector
and the specified sampling covariance matrix using the \code{type} argument
as the covariance matrix.
A replacement sampling approach is implemented
to ensure that the model-implied covariance matrix
is positive definite.
}
\examples{
# Data ---------------------------------------------------------------------
data("nas1982", package = "betaMC")

# Fit Model in lm ----------------------------------------------------------
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)

# MC -----------------------------------------------------------------------
mc <- MC(
  object,
  R = 100, # use a large value e.g., 20000L for actual research
  seed = 0508
)
mc
# The `mc` object can be passed as the first argument
# to the following functions
#   - BetaMC
#   - DeltaRSqMC
#   - DiffBetaMC
#   - PCorMC
#   - RSqMC
#   - SCorMC

}
\references{
Dudgeon, P. (2017).
Some improvements in confidence intervals
for standardized regression coefficients.
\emph{Psychometrika}, \emph{82}(4), 928–951.
\doi{10.1007/s11336-017-9563-z}

MacKinnon, D. P., Lockwood, C. M., & Williams, J. (2004).
Confidence limits for the indirect effect:
Distribution of the product and resampling methods.
\emph{Multivariate Behavioral Research}, \emph{39}(1), 99-128.
\doi{10.1207/s15327906mbr3901_4}

Pesigan, I. J. A., & Cheung, S. F. (2024).
Monte Carlo confidence intervals for the indirect effect with missing data.
\emph{Behavior Research Methods}.
\doi{10.3758/s13428-023-02114-4}

Preacher, K. J., & Selig, J. P. (2012).
Advantages of Monte Carlo confidence intervals for indirect effects.
\emph{Communication Methods and Measures}, \emph{6}(2), 77–98.
\doi{10.1080/19312458.2012.679848}
}
\seealso{
Other Beta Monte Carlo Functions: 
\code{\link{BetaMC}()},
\code{\link{DeltaRSqMC}()},
\code{\link{DiffBetaMC}()},
\code{\link{MCMI}()},
\code{\link{PCorMC}()},
\code{\link{RSqMC}()},
\code{\link{SCorMC}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Monte Carlo Functions}
\keyword{betaMC}
\keyword{mc}
