% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood_inference.R
\name{bets.inference}
\alias{bets.inference}
\title{Likelihood inference}
\usage{
bets.inference(
  data,
  likelihood = c("conditional", "unconditional"),
  ci = c("lrt", "point", "bootstrap"),
  M = Inf,
  r = NULL,
  L = NULL,
  level = 0.95,
  bootstrap = 1000,
  mc.cores = 1
)
}
\arguments{
\item{data}{A data.frame with three columns: B, E, S.}

\item{likelihood}{Conditional on B and E?}

\item{ci}{How to compute the confidence interval?}

\item{M}{Right truncation for symptom onset (only available for conditional likelihood)}

\item{r}{Parameter for epidemic growth (overrides \code{{params}, only available for conditional likelihood})}

\item{L}{Time of travel restriction (required for unconditional likelihood)}

\item{level}{Level of the confidence interval (default 0.95).}

\item{bootstrap}{Number of bootstrap resamples.}

\item{mc.cores}{Number of cores used for computing the bootstrap confidence interval.}
}
\value{
Results of the likelihood inference, including maximum likelihood estimators and individual confidence intervals for the model parameters based on inverting the likelihood ratio test.
}
\description{
Likelihood inference
}
\details{
The confidence interval is either not computed (\code{"point"}), or computed by inverting the likelihood ratio test (\code{"lrt"}) or basic bootstrap (\code{"bootstrap"})
}
\examples{

\donttest{
data(wuhan_exported)

data <- subset(wuhan_exported, Location == "Hefei")
data$B <- data$B - 0.75
data$E <- data$E - 0.25
data$S <- data$S - 0.5

# Conditional likelihood inference
bets.inference(data, "conditional")
bets.inference(data, "conditional", "bootstrap", bootstrap = 100, level = 0.5)

# Unconditional likelihood inference
bets.inference(data, "unconditional", L = 54)

# Conditional likelihood inference for data with right truncation
bets.inference(subset(data, S <= 60), "conditional", M = 60)

# Conditional likelihood inference with r fixed at 0 (not recommended)
bets.inference(data, "conditional", r = 0)
}

}
