% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicWhittle_miscellanea_zigzag.R
\name{betaBasis_k_dw}
\alias{betaBasis_k_dw}
\title{Construct Bernstein polynomial basis of degree k on omega}
\usage{
betaBasis_k_dw(omega, k, bernstein_l = 0, bernstein_r = 1)
}
\arguments{
\item{omega}{numeric vector in \eqn{[0,1]} of evaluation points}

\item{k}{positive integer for the degree}

\item{bernstein_l}{left boundary of the dilated Bernstein polynomials}

\item{bernstein_r}{right boundary of the dilated Bernstein polynomials}
}
\value{
A matrix
}
\description{
Construct Bernstein polynomial basis of degree k on omega
}
\examples{
\dontrun{
omega <- seq(0, 1, by = 0.01)
betaBasis_k_dw(omega, 100, 0.1, 0.9)
}
}
\keyword{internal}
