% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.R
\name{sp_bgsmtr_path}
\alias{sp_bgsmtr_path}
\title{A Bayesian Spatial Model for Imaging Genetics}
\usage{
sp_bgsmtr_path(lambda_v, W_est_list)
}
\arguments{
\item{lambda_v}{A vector containing all the different tuning parameter lambda-squared values for model fitting.}

\item{W_est_list}{A list containing all the estimated coefficients matrices W for each corresponding lambda squared value used in lambda_v for model fitting. Each element of this list is a d-by-c matrix.}
}
\value{
Regularization plots files in PDF format for each ROI.
}
\description{
A plotting function can be used to demonstrate the regularization paths for estimating parameters of each ROI when the spatial model is fitted with multiple values of tuning parameter lambda-squared.
}
\examples{
data(sp_bgsmtr_example_data$path_data)


\dontrun{

# Creating the regulazaition path plots  as follow:
sp_bgsmtr_path(lambda_v = sp_bgsmtr_example_data$path_data$lambda_v,
 W_est_list = sp_bgsmtr_example_data$path_data$W_est_list )

}

}
\references{
Song, Y., Ge, S., Cao, J., Wang, L., Nathoo, F.S., A Bayesian Spatial Model for Imaging Genetics. arXiv:1901.00068.
}
\author{
Yin Song, \email{yinsong@uvic.ca}

Shufei Ge, \email{shufeig@sfu.ca}

Farouk S. Nathoo, \email{nathoo@uvic.ca}

Liangliang Wang, \email{lwa68@sfu.ca}

Jiguo Cao, \email{jiguo_cao@sfu.ca}
}
