% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.pgn.db.R
\name{read.pgn.db}
\alias{read.pgn.db}
\title{Reads PGN files into database table}
\usage{
read.pgn.db(con, batch.size = 10^6, conn, table.name = "pgn", ...)
}
\arguments{
\item{con}{connection argument passed directly to readLines() function. String - the name of the file which the data are to be read from or connection object or URL.}

\item{batch.size}{number of lines to read in one batch, default is 10^6.}

\item{conn}{connection argument created by dbConnect}

\item{table.name}{string (default "pgn"), table name, used in dbWriteTable(conn, table.name, read.pgn(batch))}

\item{...}{further arguments passed directly to read.pgn() function (besides ignore.other.games and big.mode)}
}
\description{
Reads PGN files into database table
}
\examples{
\donttest{
f <- system.file("extdata", "Carlsen.gz", package = "bigchess")
con <- gzfile(f,"rbt",encoding = "latin1")
require(RSQLite)
conn <- dbConnect(SQLite())
read.pgn.db(con,stat.moves = FALSE,conn = conn)
dbGetQuery(conn, "SELECT COUNT(*) FROM pgn") #2410
dbDisconnect(conn)
# Works with all types of connections (also gz or zip files).
# con argument is passed directly to readLines(con,batch.size)
# so (if total number of lines to read is greater then batch.size)
# depending on platform use it correctly:
# Windows ('rb' opening mode for loop over readLines):
con <- gzfile(system.file("extdata", "Carlsen.gz", package = "bigchess"),"rb",encoding = "latin1")
# con <- file("path_to_big_chess_file.pgn","rb",encoding = "latin1")
read.pgn.db(con,conn = conn)
}
\donttest{
# Linux/Mac OS X ('r' opening mode for loop over readLines):
con <- gzfile(system.file("extdata", "Carlsen.gz", package = "bigchess"),"r",encoding = "latin1")
# con <- file("path_to_big_chess_file.pgn","r",encoding = "latin1")
read.pgn.db(con,conn = conn)
}
\donttest{
# Windows (example of zipped file handling)
unzf <- unzip("zipped_pgn_file.zip")
read.pgn.db(con,conn = conn)
}
}
