% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_layer_conductance.r
\name{roughness.length.heat}
\alias{roughness.length.heat}
\title{Roughness length for heat}
\usage{
roughness.length.heat(z0m, kB_h)
}
\arguments{
\item{z0m}{Roughness length for momentum (m)}

\item{kB_h}{kB-1 parameter for heat transfer}
}
\value{
Roughness length for heat, z0h (m)
}
\description{
Roughness length for heat (thermal roughness length, z0h) from the 
             kB-1 parameter and roughness length for momentum (z0m).
}
\details{
The roughness length for heat (z0h) can be calculated from the 
         following relationship (e.g. Verma 1989):
      
         \deqn{kB_h = ln(z0m/z0h)} 
      
          it follows:
      
          \deqn{z0h = z0m / exp(kB_h)}
}
\note{
If unknown, \code{z0m} can be calculated from \code{\link{roughness.parameters}}.
         \code{kB_h} can be calculated from \code{\link{Gb.Thom}}, \code{\link{Gb.Choudhury}}, \code{\link{Gb.Su}}
         or \code{\link{aerodynamic.conductance}}.
}
\examples{
roughness.length.heat(2,2.5)

}
\references{
Verma, S., 1989: Aerodynamic resistances to transfers of heat, mass and momentum.
            In: Estimation of areal evapotranspiration, IAHS Pub, 177, 13-20.
            
            Rigden, A., Li, D., Salvucci, G., 2018: Dependence of thermal roughness length on friction 
            velocity across land cover types: A synthesis analysis using AmeriFlux data. Agricultural 
            and Forest Meteorology 249, 512-519.
}
