% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation_mds.R
\name{interpolation_mds}
\alias{interpolation_mds}
\title{Interpolation MDS}
\usage{
interpolation_mds(x, l, r, n_cores)
}
\arguments{
\item{x}{A matrix with \eqn{n} individuals (rows) and \eqn{k} variables (columns).}

\item{l}{The size for which classical MDS can be computed efficiently
(using \code{cmdscale} function). It means that if \eqn{\bar{l}} is the limit
size for which classical MDS is applicable, then \code{l}\eqn{\leq \bar{l}}.}

\item{r}{Number of principal coordinates to be extracted.}

\item{n_cores}{Number of cores wanted to use to run the algorithm.}
}
\value{
Returns a list containing the following elements:
\describe{
\item{points}{A matrix that consists of \eqn{n} individuals (rows)
and \code{r} variables (columns) corresponding to the principal coordinates. Since
we are performing a dimensionality reduction, \code{r}\eqn{<<k}}
\item{eigen}{The first \code{r} largest eigenvalues:
\eqn{\lambda_i, i \in  \{1, \dots, r\} }, where each \eqn{\lambda_i} is obtained
from applying classical MDS to the first data subset.}
}
}
\description{
Given that the size of the data set is too large, this algorithm
consists of taking a random sample from it of size
\code{l} \eqn{\leq \bar{l}}, being \eqn{\bar{l}} the limit size for which
classical MDS is applicable, to perform classical MDS to it, and to extend the
obtained results to the rest of the data set by using Gower's
interpolation formula, which allows to add a new set of points
to an existing MDS configuration.
}
\details{
\emph{Gower's interpolation formula} is the central piece of this algorithm
since it allows to add a new set of points to an existing MDS configuration
so that the new one has the same coordinate system.

Given the matrix \code{x} with \eqn{n} points (rows) and
and \eqn{k} variables (columns), a first data subsets (based on a random sample)
of size \code{l} is taken and it is used to compute a MDS configuration.

The remaining part of \code{x} is divided into \eqn{p=({n}-}\code{l})\code{/l}
data subsets (randomly). For every data subset, it is obtained a MDS
configuration by means of \emph{Gower's interpolation formula} and the first
MDS configuration obtained previously. Every MDS configuration is appended
to the existing one so that, at the end of the process, a global MDS
configuration for \code{x} is obtained.

This method is similar to \code{\link[=landmark_mds]{landmark_mds()}} and \code{\link[=reduced_mds]{reduced_mds()}}.
}
\examples{
set.seed(42)
x <- matrix(data = rnorm(4 * 10000), nrow = 10000) \%*\% diag(c(9, 4, 1, 1))
mds <- interpolation_mds(x = x, l = 200, r = 2, n_cores = 1)
head(mds$points)
mds$eigen

}
\references{
Delicado P. and C. Pachón-García (2021). \emph{Multidimensional Scaling for Big Data}.
\url{https://arxiv.org/abs/2007.11919}.

Borg, I. and P. Groenen (2005). \emph{Modern Multidimensional Scaling: Theory and Applications}. Springer.

Gower JC. (1968). \emph{Adding a point to vector diagrams in multivariate analysis}. Biometrika.
}
