% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-perform.R
\name{api-perform}
\alias{api-perform}
\alias{bq_perform_extract}
\alias{bq_perform_upload}
\alias{bq_perform_load}
\alias{bq_perform_query}
\alias{bq_perform_query_dry_run}
\alias{bq_perform_query_schema}
\alias{bq_perform_copy}
\title{BigQuery jobs: perform a job}
\usage{
bq_perform_extract(
  x,
  destination_uris,
  destination_format = "NEWLINE_DELIMITED_JSON",
  compression = "NONE",
  ...,
  print_header = TRUE,
  billing = x$project
)

bq_perform_upload(
  x,
  values,
  fields = NULL,
  source_format = c("NEWLINE_DELIMITED_JSON", "PARQUET"),
  create_disposition = "CREATE_IF_NEEDED",
  write_disposition = "WRITE_EMPTY",
  ...,
  billing = x$project
)

bq_perform_load(
  x,
  source_uris,
  billing = x$project,
  source_format = "NEWLINE_DELIMITED_JSON",
  fields = NULL,
  nskip = 0,
  create_disposition = "CREATE_IF_NEEDED",
  write_disposition = "WRITE_EMPTY",
  ...
)

bq_perform_query(
  query,
  billing,
  ...,
  parameters = NULL,
  destination_table = NULL,
  default_dataset = NULL,
  create_disposition = "CREATE_IF_NEEDED",
  write_disposition = "WRITE_EMPTY",
  use_legacy_sql = FALSE,
  priority = "INTERACTIVE"
)

bq_perform_query_dry_run(
  query,
  billing,
  ...,
  default_dataset = NULL,
  parameters = NULL,
  use_legacy_sql = FALSE
)

bq_perform_query_schema(
  query,
  billing,
  ...,
  default_dataset = NULL,
  parameters = NULL
)

bq_perform_copy(
  src,
  dest,
  create_disposition = "CREATE_IF_NEEDED",
  write_disposition = "WRITE_EMPTY",
  ...,
  billing = NULL
)
}
\arguments{
\item{x}{A \link{bq_table}}

\item{destination_uris}{A character vector of fully-qualified Google Cloud
Storage URIs where the extracted table should be written. Can export
up to 1 Gb of data per file. Use a wild card URI (e.g.
\verb{gs://[YOUR_BUCKET]/file-name-*.json}) to automatically create any
number of files.}

\item{destination_format}{The exported file format:
\itemize{
\item For CSV files, specify "CSV" (Nested and repeated data is not supported).
\item For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON".
\item For Avro, specify "AVRO".
\item For parquet, specify "PARQUET".
}}

\item{compression}{The compression type to use for exported files:
\itemize{
\item For CSV files: "GZIP" or "NONE".
\item For newline-delimited JSON: "GZIP" or "NONE".
\item For Avro: "DEFLATE", "SNAPPY" or "NONE".
\item For parquet: "SNAPPY", "GZIP", "ZSTD" or "NONE".
}}

\item{...}{Additional arguments passed on to the underlying API call.
snake_case names are automatically converted to camelCase.}

\item{print_header}{Whether to print out a header row in the results.}

\item{billing}{Identifier of project to bill.}

\item{values}{Data frame of values to insert.}

\item{fields}{A \link{bq_fields} specification, or something coercible to it
(like a data frame). Leave as \code{NULL} to allow BigQuery to auto-detect
the fields.}

\item{source_format}{The format of the data files:
\itemize{
\item For CSV files, specify "CSV".
\item For datastore backups, specify "DATASTORE_BACKUP".
\item For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON".
\item For Avro, specify "AVRO".
\item For parquet, specify "PARQUET".
\item For orc, specify "ORC".
}}

\item{create_disposition}{Specifies whether the job is allowed to create
new tables.

The following values are supported:
\itemize{
\item "CREATE_IF_NEEDED": If the table does not exist, BigQuery creates the
table.
\item "CREATE_NEVER": The table must already exist. If it does not, a
'notFound' error is returned in the job result.
}}

\item{write_disposition}{Specifies the action that occurs if the
destination table already exists. The following values are supported:
\itemize{
\item "WRITE_TRUNCATE": If the table already exists, BigQuery overwrites the
table data.
\item "WRITE_APPEND": If the table already exists, BigQuery appends the data
to the table.
\item "WRITE_EMPTY": If the table already exists and contains data, a
'duplicate' error is returned in the job result.
}}

\item{source_uris}{The fully-qualified URIs that point to your data in
Google Cloud.

For Google Cloud Storage URIs: Each URI can contain one
\code{'*'} wildcard character and it must come after the 'bucket' name.
Size limits related to load jobs apply to external data sources.

For Google Cloud Bigtable URIs: Exactly one URI can be specified and
it has be a fully specified and valid HTTPS URL for a Google Cloud
Bigtable table. For Google Cloud Datastore backups: Exactly one URI
can be specified. Also, the '*' wildcard character is not allowed.}

\item{nskip}{For \code{source_format = "CSV"}, the number of header rows to skip.}

\item{query}{SQL query string.}

\item{parameters}{Named list of parameters match to query parameters.
Parameter \code{x} will be matched to placeholder \verb{@x}.

Generally, you can supply R vectors and they will be automatically
converted to the correct type. If you need greater control, you can call
\code{\link[=bq_param_scalar]{bq_param_scalar()}} or \code{\link[=bq_param_array]{bq_param_array()}} explicitly.

See \url{https://cloud.google.com/bigquery/docs/parameterized-queries}
for more details.}

\item{destination_table}{A \link{bq_table} where results should be stored.
If not supplied, results will be saved to a temporary table that lives
in a special dataset. You must supply this parameter for large
queries (> 128 MB compressed).}

\item{default_dataset}{A \link{bq_dataset} used to automatically qualify table names.}

\item{use_legacy_sql}{If \code{TRUE} will use BigQuery's legacy SQL format.}

\item{priority}{Specifies a priority for the query. Possible values include
"INTERACTIVE" and "BATCH". Batch queries do not start immediately,
but are not rate-limited in the same way as interactive queries.}
}
\value{
A \link{bq_job}.
}
\description{
These functions are low-level functions designed to be used by experts.
Each of these low-level functions is paired with a high-level function that
you should use instead:
\itemize{
\item \code{bq_perform_copy()}:    \code{\link[=bq_table_copy]{bq_table_copy()}}.
\item \code{bq_perform_query()}:   \code{\link[=bq_dataset_query]{bq_dataset_query()}}, \code{\link[=bq_project_query]{bq_project_query()}}.
\item \code{bq_perform_upload()}:  \code{\link[=bq_table_upload]{bq_table_upload()}}.
\item \code{bq_perform_load()}:    \code{\link[=bq_table_load]{bq_table_load()}}.
\item \code{bq_perform_extract()}: \code{\link[=bq_table_save]{bq_table_save()}}.
}
}
\section{Google BigQuery API documentation}{

\itemize{
\item \href{https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs}{jobs}
}

Additional information at:
\itemize{
\item \href{https://cloud.google.com/bigquery/docs/exporting-data}{exporting data}
\item \href{https://cloud.google.com/bigquery/docs/loading-data}{loading data}
\item \href{https://cloud.google.com/bigquery/docs/writing-results}{writing queries}
\item \href{https://cloud.google.com/bigquery/docs/managing-tables#copy-table}{copying a table}
}
}

\examples{
\dontshow{if (bq_testable()) withAutoprint(\{ # examplesIf}
ds <- bq_test_dataset()
bq_mtcars <- bq_table(ds, "mtcars")
job <- bq_perform_upload(bq_mtcars, mtcars)
bq_table_exists(bq_mtcars)

bq_job_wait(job)
bq_table_exists(bq_mtcars)
head(bq_table_download(bq_mtcars))
\dontshow{\}) # examplesIf}
}
\keyword{internal}
