% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binman_utils.R
\name{list_versions}
\alias{list_versions}
\title{List app versions}
\usage{
list_versions(appname, platform = c("ALL"))
}
\arguments{
\item{appname}{A character string giving the name of the application}

\item{platform}{A character vector of platforms to list. Defaults to
"ALL"}
}
\value{
A list of platforms with version directories
}
\description{
List app versions by platform
}
\examples{
\dontrun{
appdir <- app_dir("superduperapp", FALSE)
platforms <- LETTERS[1:4]
versions <- LETTERS[5:7]
mkdirs <- file.path(appdir, outer(platforms, versions, file.path))
chk <- vapply(mkdirs, dir.create, logical(1), recursive = TRUE)
expect_true(all(chk))
res <- list_versions("superduperapp")
unlink(appdir, recursive = TRUE)
}

}
