% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotvf.R
\name{plotvf_2}
\alias{plotvf_2}
\title{Plots visual field}
\usage{
plotvf_2(xs, vf, vf_norm, title = "")
}
\arguments{
\item{xs}{A vector of binocular visual field horizontal coordinates. The length of it must be 20 for a binocular visual field plot}

\item{vf}{A matrix of a binocular visual field sensitivity values}

\item{vf_norm}{A matrix a binocular healthy visual field sensitivity values for a specified distance plane}

\item{title}{A string for the name of the plot}
}
\value{
A plot of a monocular or binocular visual field
}
\description{
\code{plotvf_2} plots a figure of a binocular visual field matrix with sensitivity threshold values with missing locations
}
\section{Warning}{

the length of xs and the number of columns of the vf must be the same and with a value of either  25.
}

\examples{
c_xs <- seq(-57, 57, length.out = 20)
cvf <- matrix(c(
NA, NA, NA, NA, NA, NA, NA, NA, 30, 20, 20, 30, NA, NA, NA, NA, NA, NA, NA, NA,
NA, NA, NA, NA, NA, NA, NA, 30, 20,  0,  0, 20, 30, NA, NA, NA, NA, NA, NA, NA,
NA, NA, NA, NA, NA, NA, 30, 30, 20,  0,  0, 20, 30, 30, NA, NA, NA, NA, NA, NA,
NA, NA, NA, NA, NA, NA, 30, 30, 30, 20, 20, 30, 30, 30, NA, NA, NA, NA, NA, NA,
NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA,
NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA,
NA, NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA, NA,
NA, NA, NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA, NA, NA
), ncol=20, byrow=TRUE)
cvf_norm <- matrix(c(
 NA, NA, NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA, NA, NA,
 NA, NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA, NA,
 NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA,
 NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA,
 NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA,
 NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA,
 NA, NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA, NA,
 NA, NA, NA, NA, NA, NA, NA, NA, 30, 30, 30, 30, NA, NA, NA, NA, NA, NA, NA, NA
), ncol=20, byrow=TRUE)
plotvf_2(c_xs, cvf, cvf_norm, title='integrated visual field')
}
