% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_vpfiles.R
\name{download_vpfiles}
\alias{download_vpfiles}
\title{Download vertical profile (\code{vp}) files from the ENRAM data repository}
\usage{
download_vpfiles(
  date_min,
  date_max,
  radars,
  directory = ".",
  overwrite = FALSE
)
}
\arguments{
\item{date_min}{Character. Start date of file selection, in \code{YYYY-MM-DD}
format. Days will be ignored.}

\item{date_max}{Character. End date of file selection, in \code{YYYY-MM-DD}
format. Days will be ignored.}

\item{radars}{Character (vector). 5-letter country/radar code(s) to include
in file selection.}

\item{directory}{Character. Path to local directory where files should be
downloaded and unzipped.}

\item{overwrite}{Logical. When \code{TRUE}, re-download and overwrite previously
downloaded files of the same names.}
}
\value{
\code{NULL}. The function's primary effect is to download selected vertical profiles
files from ENRAM data repository to a specified local directory, and to provide
a message and a progress bar in the console indicating the download status. Message will show
a 404 error for files that are not available.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

This function has been superseded by \code{\link[getRad:get_vpts]{getRad::get_vpts()}}.

Download and unzip a selection of vertical profile (\code{vp}) files from the
\href{https://aloftdata.eu/}{ENRAM data repository}, where these are stored as
monthly zips per radar.
}
\examples{
\donttest{
# Download (and overwrite) data from radars "bejab" and "bewid".
download_vpfiles(
  date_min = "2018-10-01",
  date_max = "2018-10-31",
  radars = c("bejab", "bewid"),
  directory = tempdir(),
  overwrite = TRUE
)
}
}
\seealso{
\itemize{
\item \code{\link[=read_vpts]{read_vpts()}}
\item \code{\link[=select_vpfiles]{select_vpfiles()}}
\item \code{\link[=read_vpfiles]{read_vpfiles()}}
\item \code{\link[getRad:get_vpts]{getRad::get_vpts()}}
}
}
