% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSet.R
\name{getProteomeSet}
\alias{getProteomeSet}
\title{Proteome retrieval of multiple species}
\usage{
getProteomeSet(
  db = "refseq",
  organisms,
  reference = FALSE,
  release = NULL,
  skip_bacteria = TRUE,
  gunzip = TRUE,
  update = FALSE,
  path = "set_proteomes",
  mute_citation = FALSE
)
}
\arguments{
\item{db}{a character string specifying the database from which the genome
shall be retrieved:
\itemize{
\item \code{db = "refseq"}
\item \code{db = "genbank"}
\item \code{db = "ensembl"}
}}

\item{organisms}{a character vector storing the names of the organisms than shall be retrieved.
There are three available options to characterize an organism:}

\item{reference}{a logical value indicating whether or not a genome shall be downloaded if it isn't marked in the database as either a reference genome or a representative genome.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}

\item{skip_bacteria}{Due to its enormous dataset size (> 700MB as of July 2023),
the bacterial summary file will not be loaded by default anymore. If users
wish to gain insights for the bacterial kingdom they needs to actively specify \code{skip_bacteria = FALSE}. When \code{skip_bacteria = FALSE} is set then the
bacterial summary file will be downloaded.}

\item{gunzip}{a logical, indicating whether or not files should be unzipped.}

\item{update}{logical, default FALSE. Updated backend cached files needed.
Usually keep this false, to make ut run much faster. Only set to TRUE, if you
believe you cache is outdated (Species only exist in newest release etc)}

\item{path}{a character string specifying the location (a folder) in which
the corresponding proteomes shall be stored. Default is \code{path} = \code{"set_proteomes"}.}

\item{mute_citation}{logical, default FALSE, indicating whether citation message should be muted.}
}
\value{
File path to downloaded genomes
(names are identifiers: 'new' (file was downloaded now),
'old' files did already exist)
}
\description{
Main proteome retrieval function for a set of organism of interest.
By specifying the scientific names of the organisms of interest the corresponding fasta-files storing the proteome of the organisms of interest
will be downloaded and stored locally. proteome files can be retrieved from several databases.
}
\details{
Internally this function loads the the overview.txt file from NCBI:

 refseq: ftp://ftp.ncbi.nlm.nih.gov/genomes/refseq/

 genbank: ftp://ftp.ncbi.nlm.nih.gov/genomes/genbank/

and creates a directory 'set_CDSs' to store
the CDSs of interest as fasta files for future processing.
In case the corresponding fasta file already exists within the
'set_CDSs' folder and is accessible within the workspace,
no download process will be performed.
}
\examples{
\dontrun{
# download the proteomes of three different species at the same time
#### Database: NCBI RefSeq
file_paths <- getProteomeSet(db = "refseq", organisms = c("Arabidopsis thaliana",
                                      "Arabidopsis lyrata",
                                       "Capsella rubella"))
# look at file paths
file_paths

#### Database: NCBI Genbank
file_paths <- getProteomeSet(db = "genbank", organisms = c("Arabidopsis thaliana",
                                      "Arabidopsis lyrata",
                                       "Capsella rubella"))
# look at file paths
file_paths

# download the proteomes of three different species at the same time
#### Database: ENSEMBL
file_paths <- getProteomeSet(db = "ensembl", organisms = c("Homo sapiens",
                                      "Mus musculus",
                                       "Caenorhabditis elegans"))
# look at file paths
file_paths

# download the proteomes of three different species at the same time
#### Database: UniProt
file_paths <- getProteomeSet(db = "uniprot", organisms = c("Homo sapiens",
                                      "Mus musculus",
                                       "Caenorhabditis elegans"))
# look at file paths
file_paths
}

}
\seealso{
Other getBioSet: 
\code{\link{getBioSet}()},
\code{\link{getCDSSet}()},
\code{\link{getCollectionSet}()},
\code{\link{getGFFSet}()},
\code{\link{getGenomeSet}()},
\code{\link{getRNASet}()}

Other proteome: 
\code{\link{getProteome}()},
\code{\link{read_proteome}()}
}
\author{
Hajk-Georg Drost
}
\concept{getBioSet}
\concept{proteome}
