% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.r
\name{calcBMWP}
\alias{calcBMWP}
\title{Calculate BMWP indices for invertebrate samples}
\usage{
calcBMWP(df, type = "num")
}
\arguments{
\item{df}{A dataframe containing list of taxa in first column, followed by
columns of abundances with sample names in header row.}

\item{type}{Indicates format of data. Options are "num" for numeric data,
"log" for integer log abundance categories (1-5) or "alpha" for alphabetic
abundance categories (A-E). Default value is "num".}
}
\value{
A data frame consisting of columns of index values with samples in
rows.
}
\description{
Calculates BMWP, ASPT and N-taxa index values for invertebrate samples.
}
\examples{

# calculate the BMWP indices for the River Almond dataset
# 'type' not specified as data are numeric abundances

calcBMWP(almond)
}

