% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birdnet_interface.R
\name{labels_path}
\alias{labels_path}
\alias{labels_path.birdnet_model_custom}
\alias{labels_path.birdnet_model_tflite}
\alias{labels_path.birdnet_model_protobuf}
\title{Get Path to a Labels File}
\usage{
labels_path(model, ...)

\method{labels_path}{birdnet_model_custom}(model, ...)

\method{labels_path}{birdnet_model_tflite}(model, language, ...)

\method{labels_path}{birdnet_model_protobuf}(model, language, ...)
}
\arguments{
\item{model}{A BirdNET model object.}

\item{...}{Additional arguments passed to the method dispatch function.}

\item{language}{character. Specifies the language code for which the labels path is returned.
The language must be one of the available languages supported by the BirdNET model.}
}
\value{
A character string representing the file path to the labels file for the specified language.
}
\description{
This function retrieves the file path to the BirdNET labels file on your system corresponding to a specified language.
This file contains all class labels supported by the BirdNET model.

For a custom model, the path of the custom labels file is returned.
}
\note{
The \code{language} parameter must be one of the available languages returned by \code{available_languages()}.
}
\examples{
\dontrun{
model <- birdnet_model_tflite(version = "v2.4")
labels_path(model, "fr")
}
}
\seealso{
\code{\link[=available_languages]{available_languages()}} \code{\link[=read_labels]{read_labels()}}
}
