% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_shadow.R
\name{bm_shadow}
\alias{bm_shadow}
\alias{bm_shadow.bm_bitmap}
\alias{bm_shadow.bm_list}
\alias{bm_shadow.bm_pixmap}
\alias{bm_shadow.magick-image}
\alias{bm_shadow.nativeRaster}
\alias{bm_shadow.raster}
\alias{bm_bold}
\alias{bm_bold.bm_bitmap}
\alias{bm_bold.bm_list}
\alias{bm_bold.bm_pixmap}
\alias{bm_bold.magick-image}
\alias{bm_bold.nativeRaster}
\alias{bm_bold.raster}
\alias{bm_glow}
\alias{bm_glow.bm_bitmap}
\alias{bm_glow.bm_list}
\alias{bm_glow.bm_pixmap}
\alias{bm_glow.magick-image}
\alias{bm_glow.nativeRaster}
\alias{bm_glow.raster}
\title{Bitmap shadow, bold, and glow effects}
\usage{
bm_shadow(
  x,
  value,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE,
  bg
)

\method{bm_shadow}{bm_bitmap}(
  x,
  value = 2L,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE,
  bg = 0L
)

\method{bm_shadow}{bm_list}(x, ...)

\method{bm_shadow}{bm_pixmap}(
  x,
  value = col2hex("black"),
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE,
  bg = col2hex("transparent")
)

\method{bm_shadow}{`magick-image`}(
  x,
  value = "black",
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE,
  bg = "transparent"
)

\method{bm_shadow}{nativeRaster}(
  x,
  value = col2int("black"),
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE,
  bg = "transparent"
)

\method{bm_shadow}{raster}(
  x,
  value = "black",
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE,
  bg = "transparent"
)

bm_bold(
  x,
  value = 1L,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE
)

\method{bm_bold}{bm_bitmap}(
  x,
  value = 1L,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE
)

\method{bm_bold}{bm_list}(x, ...)

\method{bm_bold}{bm_pixmap}(
  x,
  value = col2hex("black"),
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE
)

\method{bm_bold}{`magick-image`}(
  x,
  value = "black",
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE
)

\method{bm_bold}{nativeRaster}(
  x,
  value = col2int("black"),
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE
)

\method{bm_bold}{raster}(
  x,
  value = "black",
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE
)

bm_glow(x, value, extend = TRUE, corner = FALSE, bg)

\method{bm_glow}{bm_bitmap}(x, value = 2L, extend = TRUE, corner = FALSE, bg = 0L)

\method{bm_glow}{bm_list}(x, ...)

\method{bm_glow}{bm_pixmap}(
  x,
  value = col2hex("black"),
  extend = TRUE,
  corner = FALSE,
  bg = col2hex("transparent")
)

\method{bm_glow}{`magick-image`}(x, value = "black", extend = TRUE, corner = FALSE, bg = "transparent")

\method{bm_glow}{nativeRaster}(x, value = "black", extend = TRUE, corner = FALSE, bg = "transparent")

\method{bm_glow}{raster}(x, value = "black", extend = TRUE, corner = FALSE, bg = "transparent")
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}

\item{value}{The integer value for the shadow, bold, or glow effect.}

\item{top}{How many pixels above should the shadow go.}

\item{right}{How many pixels right should the shadow go.
if \code{top}, \code{right}, \code{bottom}, and \code{left} are all \code{NULL} then defaults to \code{1L}.}

\item{bottom}{How many pixels below should the shadow go.
if \code{top}, \code{right}, \code{bottom}, and \code{left} are all \code{NULL}
then defaults to \code{1L} for \code{bm_shadow()} and \code{0L} for \code{bm_embolden()}.}

\item{left}{How many pixels left should the shadow go.}

\item{extend}{Make the bitmap larger to give the new glyph more "room".}

\item{bg}{Bitmap background value.}

\item{...}{Additional arguments to be passed to or from methods.}

\item{corner}{Fill in the corners.}
}
\value{
Depending on \code{x} either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{magick-image}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{raster}  object.
}
\description{
\code{bm_shadow()} adds a basic "shadow" effect to the bitmap(s).
\code{bm_bold()} is a variant with different defaults to create a basic "bold" effect.
\code{bm_glow()} adds a basic "glow" effect to the bitmap(s).
}
\examples{
font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
font <- read_hex(font_file)
capital_r <- font[[str2ucp("R")]]
print(capital_r)
print(bm_shadow(capital_r))
print(bm_bold(capital_r))
print(bm_glow(capital_r))
print(bm_glow(capital_r, corner = TRUE))

corn <- farming_crops_16x16()$corn$portrait
corn_shadow <- bm_shadow(corn, "red")
if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(corn_shadow, compress = "v")
}

corn_glow <- bm_glow(corn, "cyan", corner = TRUE)
if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(corn_glow, compress = "v")
}
}
\seealso{
\code{\link[=bm_extend]{bm_extend()}} and \code{\link[=bm_shift]{bm_shift()}}
}
