% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Student.R
\name{toer,Student-method}
\alias{toer,Student-method}
\title{Type I Error Rate}
\usage{
\S4method{toer}{Student}(
  design,
  n1,
  nuisance,
  recalculation = TRUE,
  iters = 10000,
  seed = NULL,
  allocation = c("approximate", "exact"),
  ...
)
}
\arguments{
\item{design}{Object of class \code{Student} created by \code{setupStudent}.}

\item{n1}{Either the sample size of the first stage (if
\code{recalculation = TRUE} or the toal sample size (if
\code{recalculation = FALSE}).}

\item{nuisance}{Value of the nuisance parameter. For the
Student's t-test this is the variance.}

\item{recalculation}{Should the sample size be recalculated after n1
patients are recruited?}

\item{iters}{Number of simulation iterations.}

\item{seed}{Random seed for simulation.}

\item{allocation}{Whether the allocation ratio should be preserved
exactly (\code{exact}) or approximately (\code{approximate}).}

\item{...}{Further optional arguments.}
}
\value{
One type I error rate value for every nuisance parameter
 and every value of n1.
}
\description{
Computes the type I error rate of designs with blinded sample size
recalculation or of fixed designs for one or several values of the nuisance
parameter.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.
}
\examples{
d <- setupStudent(alpha = .025, beta = .2, r = 1, delta = 3.5, delta_NI = 0,
                  alternative = "greater", n_max = 156)
toer(d, n1 = 20, nuisance = 5.5, recalculation = TRUE)

}
