% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{predict_bliss_distribution}
\alias{predict_bliss_distribution}
\title{predict_bliss_distribution}
\usage{
predict_bliss_distribution(x, grids, burnin, posterior_sample, beta_sample)
}
\arguments{
\item{x}{a list containing the design matrices related to the functional
covariates. Must be similar to the result of the function \code{sim_x}.}

\item{grids}{a list of numerical vectors, the qth vector is the grid of
time points for the qth functional covariate.}

\item{burnin}{an integer (optional), the number of iteration to drop from the
posterior sample.}

\item{posterior_sample}{a list provided by the function \code{Bliss_Gibbs_Sampler}.}

\item{beta_sample}{a list provided by the function \code{compute_beta_sample}.}
}
\value{
A matrix containing predictions for each individual data \code{x}.
}
\description{
Compute the distribution of the predictions.
}
\examples{
\donttest{
data(data1)
data(param1)
data(res_bliss1)

predict_bliss_distribution(data1$x,data1$grids,50,res_bliss1$posterior_sample,
   res_bliss1$beta_sample)
}
}
