% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-kraken2-tools.R
\name{kraken_tools}
\alias{kraken_tools}
\title{KrakenTools is a suite of scripts to be used alongside the Kraken,
KrakenUniq, Kraken 2, or Bracken programs.}
\usage{
kraken_tools(script, ..., python = NULL)
}
\arguments{
\item{script}{Name of the kraken2 script. One of
\code{"combine_kreports"}, \code{"combine_mpa"}, \code{"extract_kraken_reads"}, \code{"filter_bracken_out"}, \code{"fix_unmapped"}, \code{"kreport2krona"}, \code{"kreport2mpa"}, \code{"make_kreport"}, and \code{"make_ktaxonomy"}.}

\item{...}{<\link[rlang:dyn-dots]{dynamic dots}> Additional arguments passed to \code{kraken_tools} command. Empty arguments are automatically trimmed. If a single argument, such as a file path, contains spaces, it must be quoted, for example using \code{\link[=shQuote]{shQuote()}}. Details see: \code{cmd_help(kraken_tools())}.}

\item{python}{A string of path to \code{python} command.}
}
\value{
A \code{command} object.
}
\description{
These scripts are designed to help Kraken users with downstream
analysis of Kraken results.
}
\seealso{
\itemize{
\item \url{https://github.com/jenniferlu717/KrakenTools}
\item \code{\link[=cmd_wd]{cmd_wd()}}/\code{\link[=cmd_envvar]{cmd_envvar()}}/\code{\link[=cmd_envpath]{cmd_envpath()}}/\code{\link[=cmd_conda]{cmd_conda()}}
\item \code{\link[=cmd_on_start]{cmd_on_start()}}/\code{\link[=cmd_on_exit]{cmd_on_exit()}}
\item \code{\link[=cmd_on_succeed]{cmd_on_succeed()}}/\code{\link[=cmd_on_fail]{cmd_on_fail()}}
\item \code{\link[=cmd_parallel]{cmd_parallel()}}
}

Other \code{commands}:
\code{\link{allele_counter}()},
\code{\link{cellranger}()},
\code{\link{conda}()},
\code{\link{fastq_pair}()},
\code{\link{gistic2}()},
\code{\link{kraken2}()},
\code{\link{perl}()},
\code{\link{pyscenic}()},
\code{\link{python}()},
\code{\link{samtools}()},
\code{\link{seqkit}()},
\code{\link{trust4}()}
}
\concept{command}
