% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-trust4.R
\name{trust4}
\alias{trust4}
\alias{trust4_imgt_annot}
\alias{trust4_gene_names}
\title{TRUST4: immune repertoire reconstruction from bulk and single-cell RNA-seq
data}
\usage{
trust4(
  file1,
  ref_coordinate,
  ...,
  file2 = NULL,
  mode = NULL,
  ref_annot = NULL,
  ofile = NULL,
  odir = getwd(),
  trust4 = NULL
)

trust4_imgt_annot(
  species = "Homo_sapien",
  ...,
  ofile = "IMGT+C.fa",
  odir = getwd(),
  perl = NULL
)

trust4_gene_names(imgt_annot, ofile = "bcr_tcr_gene_name.txt", odir = getwd())
}
\arguments{
\item{file1}{Path to bam file or fastq file.}

\item{ref_coordinate}{Path to the fasta file coordinate and sequence of
V/D/J/C genes.}

\item{...}{\itemize{
\item \code{trust4}: <\link[rlang:dyn-dots]{dynamic dots}> Additional arguments passed to \code{run-trust4} command. Empty arguments are automatically trimmed. If a single argument, such as a file path, contains spaces, it must be quoted, for example using \code{\link[=shQuote]{shQuote()}}. Details see: \code{cmd_help(run-trust4())}.
\item \code{trust4_imgt_annot}: <\link[rlang:dyn-dots]{dynamic dots}> Additional arguments passed to \code{trust4_imgt_annot} command. Empty arguments are automatically trimmed. If a single argument, such as a file path, contains spaces, it must be quoted, for example using \code{\link[=shQuote]{shQuote()}}. Details see: \code{cmd_help(trust4_imgt_annot())}.
}}

\item{file2}{Path to the second paired-end read fastq file, only used for
\code{mode = "fastq"}.}

\item{mode}{One of "bam" or "fastq". If \code{NULL}, will be inferred from
\code{file1}.}

\item{ref_annot}{Path to detailed V/D/J/C gene reference file, such as from
IMGT database. (default: not used). (recommended).}

\item{ofile}{\itemize{
\item \code{trust4}: Prefix of output files. (default: inferred from file prefix).
\item \code{trust4_imgt_annot}: Output file name.
\item \code{trust4_gene_names}: Output file name.
}}

\item{odir}{A string of path to the output directory.}

\item{trust4}{A string of path to \code{run-trust4} command.}

\item{species}{Species to extract IMGT annotation, details see
\url{https://www.imgt.org//download/V-QUEST/IMGT_V-QUEST_reference_directory/}.}

\item{perl}{A string of path to \code{perl} command.}

\item{imgt_annot}{Path of IMGT annotation file, created via
\code{trust4_imgt_annot}.}
}
\value{
A \code{command} object.
}
\description{
TRUST4: immune repertoire reconstruction from bulk and single-cell RNA-seq
data
}
\seealso{
\itemize{
\item \url{https://github.com/liulab-dfci/TRUST4}
\item \code{\link[=cmd_wd]{cmd_wd()}}/\code{\link[=cmd_envvar]{cmd_envvar()}}/\code{\link[=cmd_envpath]{cmd_envpath()}}/\code{\link[=cmd_conda]{cmd_conda()}}
\item \code{\link[=cmd_on_start]{cmd_on_start()}}/\code{\link[=cmd_on_exit]{cmd_on_exit()}}
\item \code{\link[=cmd_on_succeed]{cmd_on_succeed()}}/\code{\link[=cmd_on_fail]{cmd_on_fail()}}
\item \code{\link[=cmd_parallel]{cmd_parallel()}}
}

Other \code{commands}:
\code{\link{allele_counter}()},
\code{\link{cellranger}()},
\code{\link{conda}()},
\code{\link{fastq_pair}()},
\code{\link{gistic2}()},
\code{\link{kraken2}()},
\code{\link{kraken_tools}()},
\code{\link{perl}()},
\code{\link{pyscenic}()},
\code{\link{python}()},
\code{\link{samtools}()},
\code{\link{seqkit}()}
}
\concept{command}
