% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board-options.R, R/board-ui.R
\name{board_ui.board_options}
\alias{board_ui.board_options}
\alias{update_ui.board_options}
\alias{board_ui}
\alias{board_ui.board}
\alias{board_ui.NULL}
\alias{insert_block_ui}
\alias{insert_block_ui.board}
\alias{remove_block_ui}
\alias{remove_block_ui.board}
\alias{update_ui}
\alias{update_ui.board}
\title{Board UI}
\usage{
\method{board_ui}{board_options}(id, x, ...)

\method{update_ui}{board_options}(x, session, ...)

board_ui(id, x, ...)

\method{board_ui}{board}(id, x, plugins = list(), ...)

\method{board_ui}{`NULL`}(id, x, ...)

insert_block_ui(id, x, blocks = NULL, ...)

\method{insert_block_ui}{board}(id, x, blocks = NULL, ...)

remove_block_ui(id, x, blocks = NULL, ...)

\method{remove_block_ui}{board}(id, x, blocks = NULL, ...)

update_ui(x, session, ...)

\method{update_ui}{board}(x, session, ...)
}
\arguments{
\item{id}{Namespace ID}

\item{x}{Board}

\item{...}{Generic consistency}

\item{session}{Shiny session}

\item{plugins}{UI for board plugins}

\item{blocks}{(Additional) blocks (or IDs) for which to generate the UI}
}
\value{
A \code{board_ui()} implementation is expected to return \link[shiny:reexports]{shiny::tag} or
\code{\link[shiny:reexports]{shiny::tagList()}} objects, while updater functions (\code{insert_block_ui()},
\code{remove_block_ui()} and \code{update_ui()}) are called for their side effects
(which includes UI updates such as \code{\link[shiny:insertUI]{shiny::insertUI()}}, \code{\link[shiny:insertUI]{shiny::removeUI()}})
and return the board object passed as \code{x} invisibly.
}
\description{
As counterpart to \code{\link[=board_server]{board_server()}}, \code{board_ui()} is responsible for rendering
UI for a board module. This top-level entry point for customizing board
appearance and functionality can be overridden by sub-classing the boar
object and providing an implementation for this sub-class. Such an
implementation is expected to handle UI for plugins and all board
components, including blocks, links and stacks, but may rely on
functionality that generates UI for these components, such as \code{\link[=block_ui]{block_ui()}}
or \code{\link[=stack_ui]{stack_ui()}}, as well as already available UI provided by plugins
themselves.
}
\details{
Dynamic UI updates are handled by functions \code{insert_block_ui()} and
\code{remove_block_ui()} for adding and removing block-level UI elements to and
from \code{board} UI, whenever blocks are added or removed. The lightly more
nondescript updated function \code{update_ui()} is intended for board-level UI
updates, which is currently only needed when restoring from a saved state and
board option UI needs to be adjusted accordingly. All these update functions
are provided as S3 generics with implementations for \code{board} and can be
extended if so desired.
}
