% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-stacks.R
\name{manage_stacks}
\alias{manage_stacks}
\alias{manage_stacks_server}
\alias{manage_stacks_ui}
\title{Plugin module for managing board stacks}
\usage{
manage_stacks(server = manage_stacks_server, ui = manage_stacks_ui)

manage_stacks_server(id, board, update, ...)

manage_stacks_ui(id, board)
}
\arguments{
\item{server, ui}{Server/UI for the plugin module}

\item{id}{Namespace ID}

\item{board}{The initial \code{board} object}

\item{update}{Reactive value object to initiate board updates}

\item{...}{Extra arguments passed from parent scope}
}
\value{
A plugin container inheriting from \code{manage_stacks} is returned by
\code{manage_stacks()}, while the UI component (e.g. \code{manage_stacks_ui()}) is
expected to return shiny UI (i.e. \code{\link[shiny:reexports]{shiny::tagList()}}) and the server
component (i.e. \code{manage_stacks_server()}) is expected to return \code{NULL}.
}
\description{
Logic and user experience for adding new, removing and modifying existing
stacks to/from the board can be customized or enhanced by providing an
alternate version of this plugin. The default implementation provides a
table-based UI, presented in a modal.
}
\details{
Updates are mediated via the \code{\link[shiny:reactiveVal]{shiny::reactiveVal()}} object passed as
\code{update}, where stack updates are communicated as list entry \code{stacks} with
components \code{add}, \code{rm} or \code{mod}, where
\itemize{
\item \code{add} is either \code{NULL} or a \code{stacks} object (stack IDs may not already
exists),
\item \code{rm} is either \code{NULL} or a character vector of (existing) stack IDs,
\item \code{mod} is either \code{NULL} or a \code{stacks} object (where stack IDs must already
exist).
}
}
