% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board-plugins.R
\name{new_plugin}
\alias{new_plugin}
\alias{is_plugin}
\alias{as_plugin}
\alias{board_plugins}
\alias{plugins}
\alias{is_plugins}
\alias{as_plugins}
\alias{validate_plugins}
\title{Board plugin}
\usage{
new_plugin(
  server,
  ui = NULL,
  validator = function(x, ...) x,
  class = character()
)

is_plugin(x)

as_plugin(x)

board_plugins(which = NULL)

plugins(...)

is_plugins(x)

as_plugins(x)

validate_plugins(x)
}
\arguments{
\item{server, ui}{Server/UI for the plugin module}

\item{validator}{Validator function that validates server return values}

\item{class}{Plugin subclass}

\item{x}{Plugin object}

\item{which}{(Optional) character vectors of plugins to include}

\item{...}{Plugin objects}
}
\value{
Constructors \code{new_plugin()}/\code{plugins()} return \code{plugin} and
\code{plugins} objects, respectively, as do \code{as_plugin()}/\code{as_plugins()} and
validators \code{validate_plugin()}/\code{validate_plugins()}, which are typically
called for their side effects of throwing errors in case of validation
failure. Inheritance checkers \code{is_plugin()}/\code{is_plugins()} return scalar
logicals and finally, the convenience function \code{board_plugins()} returns a
\code{plugins} object with all known plugins (or a selected subset thereof).
}
\description{
A core mechanism for extending or customizing UX aspects of the board module
is a "plugin" architecture. All plugins inherit from \code{plugin} and a sub-class
is assigned to each specific plugin. The "manage blocks" plugin for example
has a class vector \code{c("manage_blocks", "plugin")}. Sets of plugins are
handled via a wrapper class \code{plugins}. Each plugin needs a server component,
in most cases accompanied by a UI component and is optionally bundled with a
validator function.
}
\examples{
plg <- board_plugins()

is_plugins(plg)
names(plg)

plg[1:3]

is_plugin(plg[["preserve_board"]])

}
