% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bls_key.R
\name{bls-api-key}
\alias{bls-api-key}
\alias{bls_set_key}
\alias{bls_unset_key}
\alias{bls_get_key}
\alias{bls_has_key}
\title{Managing API keys}
\usage{
bls_set_key(key)

bls_unset_key()

bls_get_key()

bls_has_key()
}
\arguments{
\item{key}{A valid BLS API key as a string. keys are typically 32 characters
in length and a key with a different length will trigger a warning.}
}
\description{
It is strongly recommended users of the BLS API use an API key. This key can
be stored as environment variable, \code{BLS_API_KEY}.
\itemize{
\item \code{bls_get_key()} will retrieve the key, if set, or it will return \code{NULL}
if the key has not been set or has been unset.
\item \code{bls_set_key()} will set the key \emph{for the current R session}. For
persistence across sessions, set the environment variable.
See the Persistence section for more information.
\item \code{bls_unset_key()} will unset the key \emph{for the current R session}.
\item \code{bls_has_key()} returns \code{TRUE} if a key can be found. Otherwise it
returns \code{FALSE}.
}
}
\section{Registering for and using an API key}{


Registering for an API key is not required to use the BLS API, but it is
recommended you register for an API key and use it. Requests without a key
are limited to 10 years of data per request, 25 series per query, and 25
queries per day. You can register for an API key at:
\url{https://data.bls.gov/registrationEngine/}
}

\section{Persistence}{


The preferred method to set the key is to set the \code{BLS_API_KEY}
environment variable in an \code{.Renviron} file. The easiest way to do this is
by calling \code{usethis::edit_r_environ()}. Don't forget to restart R after
setting the key.
}

\examples{

has_key <- bls_has_key()

if(has_key){
  original_key <- bls_get_key()
  bls_unset_key()
}

#no initial key
bls_has_key()

# Set a session key
bls_set_key("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")

bls_has_key()

# Get session key
bls_get_key()

# Reset to original key
if(has_key) bls_set_key(original_key)
}
\seealso{
Other blsR-utils: 
\code{\link{data_as_table}()},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_request_queries}()},
\code{\link{span_series_request}()},
\code{\link{tidy_periods}()},
\code{\link{tidy_table_as_zoo}()}

Other blsR-utils: 
\code{\link{data_as_table}()},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_request_queries}()},
\code{\link{span_series_request}()},
\code{\link{tidy_periods}()},
\code{\link{tidy_table_as_zoo}()}

Other blsR-utils: 
\code{\link{data_as_table}()},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_request_queries}()},
\code{\link{span_series_request}()},
\code{\link{tidy_periods}()},
\code{\link{tidy_table_as_zoo}()}

Other blsR-utils: 
\code{\link{data_as_table}()},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_request_queries}()},
\code{\link{span_series_request}()},
\code{\link{tidy_periods}()},
\code{\link{tidy_table_as_zoo}()}
}
\concept{blsR-utils}
