% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_m3.R
\name{construct_m3_act_funs}
\alias{construct_m3_act_funs}
\title{Get Activation Functions for different M3 versions}
\usage{
construct_m3_act_funs(model = NULL, warnings = TRUE)
}
\arguments{
\item{model}{A bmmodel object that specifies the M3 model for which the
activation functions should be generated. If no model is passed the available
M3 versions will be printed to the console.}

\item{warnings}{Logical flag to indicate if information about the generated model formulas
should be printed when the function is called.}
}
\value{
A bmmformula object with the activation functions for the m3 version specified in
the model object. The activation functions use the names of the response categories
specified in the model object.
}
\description{
This function generates the activation functions for different versions of the Memory
Measurement Model (m3) implemented in the \code{bmm} package. If no \code{bmmodel} object is
passed then it will print the available model versions.
}
\examples{
model <- m3(
 resp_cats = c("correct","other", "npl"),
 num_options = c(1, 4, 5),
 version = "ss"
)

construct_m3_act_funs(model, warnings = FALSE)
}
\keyword{transform}
