% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-health.R
\name{boilerplate_check_health}
\alias{boilerplate_check_health}
\title{Check Database Health}
\usage{
boilerplate_check_health(db, fix = FALSE, report = NULL, quiet = FALSE)
}
\arguments{
\item{db}{List. The database to check (can be unified or single category).}

\item{fix}{Logical. If TRUE, attempts to fix issues where possible. Default FALSE.}

\item{report}{Character or NULL. If a file path is provided, saves a detailed report.
If "text", returns the report as a character string. If NULL (default), returns
the health check object.}

\item{quiet}{Logical. If TRUE, suppresses non-critical messages. Default FALSE.}
}
\value{
Depends on the \code{report} parameter:
\itemize{
\item If \code{report = NULL}: A list with class "boilerplate_health" containing summary,
issues, stats, and fixed items
\item If \code{report = "text"}: A character string containing the detailed report
\item If \code{report} is a file path: Invisibly returns the file path after saving report
}
}
\description{
Performs comprehensive health checks on a boilerplate database to identify
potential issues such as orphaned variables, empty entries, and structural problems.
Can optionally generate a detailed report.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise and import database
boilerplate_init(data_path = temp_dir, create_dirs = TRUE,
                 confirm = FALSE, quiet = TRUE)
db <- boilerplate_import(data_path = temp_dir, quiet = TRUE)

# Check database health
health <- boilerplate_check_health(db)
print(health)

# Generate text report
report_text <- boilerplate_check_health(db, report = "text")
cat(report_text)

# Save report to file
report_file <- file.path(temp_dir, "health_report.txt")
boilerplate_check_health(db, report = report_file)

# Check and fix issues
health <- boilerplate_check_health(db, fix = TRUE)

# Get the fixed database
if (health$summary$issues_fixed > 0) {
  db <- attr(health, "fixed_db")
}

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
