% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migration-utilities.R
\name{validate_json_database}
\alias{validate_json_database}
\title{Validate JSON Database Against Schema}
\usage{
validate_json_database(json_file, type = "unified")
}
\arguments{
\item{json_file}{Path to JSON file to validate}

\item{type}{Database type ("methods", "measures", "results", "discussion",
"appendix", "template", "unified"). Default is "unified".}
}
\value{
Character vector of validation errors (empty if valid)
}
\description{
Validates a JSON database file against the appropriate JSON schema to ensure
data integrity and structure compliance.
}
\details{
Uses JSON Schema Draft 7 for validation via the jsonvalidate package.
Schemas define required fields, data types, and structure for each database
type. This ensures consistency across different database files and helps
catch errors early.

If jsonvalidate is not installed, validation is skipped with a message.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Create sample JSON database
sample_db <- list(
  measures = list(
    anxiety = list(name = "Anxiety Scale", items = 10)
  )
)
json_path <- file.path(temp_dir, "measures_db.json")
if (requireNamespace("jsonlite", quietly = TRUE)) {
  jsonlite::write_json(sample_db, json_path)
  
  # Validate a measures database
  errors <- validate_json_database(json_path, "measures")
  if (length(errors) == 0) {
    message("Database is valid!")
  } else {
    cat("Validation errors:\n", paste(errors, collapse = "\n"))
  }
}

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
\seealso{
\code{\link{boilerplate_migrate_to_json}}
}
