% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d05b_computingModifDurationUsingMacDuration.R
\name{modifDurationUsingMacDuration}
\alias{modifDurationUsingMacDuration}
\title{Calculates Modified Duration using the Macaulay Duration and Yield-To-Maturity.}
\usage{
modifDurationUsingMacDuration(macDuration, ytm)
}
\arguments{
\item{macDuration}{A number.}

\item{ytm}{A number.}
}
\value{
Input values to two arguments  \code{macDuration}  and \code{ytm}.
}
\description{
Calculates Modified Duration using the Macaulay Duration and Yield-To-Maturity.
}
\details{
According to information provided by Adams and Smith (2019), the method \code{modifDurationUsingMacDuration()} is developed to calculate Modified Duration using the Macaulay Duration and Yield-To-Maturity.
}
\examples{
modifDurationUsingMacDuration(macDuration=12.6213,ytm=0.06/2)
modifDurationUsingMacDuration(macDuration=7.0029,ytm=0.104)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Understanding Fixed‑Income Risk and Return. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 237-299). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
