% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Get Data}
\usage{
get_data(variable, geography, time = NULL)
}
\arguments{
\item{variable}{variable identifier as character string}

\item{geography}{geography identifier as character string}

\item{time}{time identifier as vector of character strings}
}
\value{
a \code{data.frame} with columns \code{Schlüssel} (unit identifier), 
\code{Raumbezug} (geography identifier), \code{Indikator} (variable identifier), 
\code{Wert} (value) and \code{time} (year or time period).
}
\description{
\code{get_data} retrieves a data frame with all available values for a variable
}
\details{
To get a list of available geographies use \code{\link{get_geographies}}. To 
get a list of available variables use \code{\link{get_variables}}. 

The function retrieves all values for all available years by default.
}
\examples{
# The SSL vertification seems to fail for some Linux systems. 
# This is likely because of a SSL certificate issue on the INKAR server. 
# Disabling SSL verification comes with risks: 
# https://curl.se/libcurl/c/CURLOPT_SSL_VERIFYPEER.html
httr::set_config(httr::config(ssl_verifypeer = 0L))

# GDP for all districts/all available years
get_data(variable="011", geography="KRE")

# Reset configuration  
httr::reset_config()





}
\seealso{
\code{\link{get_geographies}} \code{\link{get_variables}} \code{\link{get_metadata}}
}
