% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geographies.R
\name{get_geographies}
\alias{get_geographies}
\title{Get Available Geographies}
\usage{
get_geographies(geography = NULL)
}
\arguments{
\item{geography}{geography as string or \code{NULL}}
}
\value{
a \code{data.frame} either with the columns \code{Kurzname} (geography name), \code{ID} (geography identifier) 
and \code{NGeb} (number of units) or with the columns \code{Schlüssel} (unit identifier) and \code{Name} (unit name).
}
\description{
\code{get_geographies} either retrieves a data frame with all available geographies or all existing units for a given geography
}
\examples{

# The SSL vertification seems to fail for some Linux systems. 
# This is likely because of a SSL certificate issue on the INKAR server. 
# Disabling SSL verification comes with risks: 
# https://curl.se/libcurl/c/CURLOPT_SSL_VERIFYPEER.html
httr::set_config(httr::config(ssl_verifypeer = 0L))

# Available geographies  
get_geographies()

# All districts 
get_geographies("KRS")

# Reset configuration  
httr::reset_config()

}
