% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahr_estimation.R
\name{ahr_from_km}
\alias{ahr_from_km}
\title{Average Hazard Estimation based on Kaplan-Meier Estimates}
\usage{
ahr_from_km(resp, trt, data, status, t_quantile = 0.99)
}
\arguments{
\item{resp}{(\code{string})\cr the response variable name.}

\item{trt}{(\code{string})\cr the treatment variable name. The treatment variable
must be a factor with 2 levels where the first level is the control and the
second one the treatment.}

\item{data}{(\verb{data frame})\cr the data frame with the variables.}

\item{status}{(\code{string})\cr the status variable name in survival data.}

\item{t_quantile}{(\code{number})\cr definition of the quantile.}
}
\value{
The estimated average hazard ratio of the treatment (second level of \code{trt})
versus the control (first level of \code{trt}).
}
\description{
Average Hazard Estimation based on Kaplan-Meier Estimates
}
\details{
Estimates can be unstable due to the variability of the Kaplan-Meier estimates
in the tails. The \code{t_quantile} argument can address this, e.g. by setting it to
0.95, the 5\% highest times will be discarded. By default, the 1\% highest times
are discarded.
}
\examples{
ahr_from_km("tt_pfs", "arm", example_data, "ev_pfs")
ahr_from_km("tt_pfs", "arm", example_data, "ev_pfs", t_quantile = 0.95)
}
