% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/booami_sim.R
\docType{data}
\name{booami_sim}
\alias{booami_sim}
\title{Example dataset for 'booami' (Gaussian, MAR)}
\format{
A data frame with 300 rows and 26 variables:
\describe{
\item{X1}{numeric}
\item{X2}{numeric}
\item{X3}{numeric}
\item{X4}{numeric}
\item{X5}{numeric}
\item{X6}{numeric}
\item{X7}{numeric}
\item{X8}{numeric}
\item{X9}{numeric}
\item{X10}{numeric}
\item{X11}{numeric}
\item{X12}{numeric}
\item{X13}{numeric}
\item{X14}{numeric}
\item{X15}{numeric}
\item{X16}{numeric}
\item{X17}{numeric}
\item{X18}{numeric}
\item{X19}{numeric}
\item{X20}{numeric}
\item{X21}{numeric}
\item{X22}{numeric}
\item{X23}{numeric}
\item{X24}{numeric}
\item{X25}{numeric}
\item{y}{numeric outcome}
}
}
\description{
A simulated dataset with predictors \code{X1}...\code{X25} and a continuous
outcome \code{y}, with missing values generated under a MAR mechanism. The
object is a \code{data.frame} and carries attributes describing the
data-generating process (true coefficients, informative indices, etc.).
}
\details{
Generated by \code{\link{simulate_booami_data}} with typical settings (see
\code{?simulate_booami_data}). The following attributes are attached to
\code{booami_sim}:
\itemize{
\item \code{"true_beta"}: numeric length-25 vector of true coefficients
(non-zeros in positions 1-5).
\item \code{"informative"}: integer vector \code{1:5}.
\item \code{"type"}: \code{"gaussian"}.
\item \code{"corr_structure"}: \code{"all_ar1"}; \code{"rho"}: 0.3.
\item \code{"intercept"}: 1; \code{"noise_sd"}: 1 (Gaussian; \code{NA} otherwise).
\item \code{"mar_scale"}: \code{TRUE}; \code{"keep_mar_drivers"}: \code{TRUE}.
}
}
\examples{
## \donttest{
utils::data(booami_sim)
dim(booami_sim)
mean(colSums(is.na(booami_sim)) > 0)  # fraction of columns with any NAs
head(attr(booami_sim, "true_beta"))
attr(booami_sim, "informative")
## }

}
\seealso{
\code{\link{simulate_booami_data}},
\code{\link{impu_boost}}, \code{\link{cv_boost_raw}}, \code{\link{cv_boost_imputed}}
}
\keyword{datasets}
