##
# ------------------------------------------------------------------------
#
# "summary.boodd <- function(object,...)" --
#
# Print a summary of an object of class 'boodd' returned by
# the boots/bootsemi/blockboot/regenboot/etc functions.
#
# ------------------------------------------------------------------------
##
#' @aliases summary.boodd
#' @title Summary for Objects of Class boodd
#' @description The bootstrap functions return an object of class \code{boodd}
#' containing the generated data. The generic function \code{summary} may be
#' applied to these objects.
#' @param object An object of class \code{boodd}.
#' @param ... Additional arguments affecting the summary produced.
#' @details The function \code{summary.boodd} displays basic information about
#' the values of the samples computed by the bootsrap functions.
#' @return The function \code{summary.boodd} returns the \code{kind} attribute
#' of the function that produced the \code{boodd} object and a (possibly
#' multicolumn) table with the quartiles, mean, min and max of the computed 
#' values of the statistic. The number of columns is the size of the return 
#' value of the function \code{func}.
#' @references Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for 
#' Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.
#' 
#' Efron, B., Tibshirani, R. (1993). \emph{An Introduction to the
#'  Bootstrap}, Chapman and Hall.
#' @seealso \code{\link{confint.boodd}}, \code{\link{boots}}, \code{\link{class.boodd}}.
#' @keywords Bootstrap
#' @export
#' @examples 
#' B <- 299
#' x <- round(rnorm(15),3)
#' boo1 <- blockboot(x,mean,B, method="circular")
#' summary(boo1)
#' 
#' 
#' # bootstrap of several statistics 
#' mv <- function(data) {c(mean(data),var(data))} # compute both mean and variance
#' boo2 <- boots(x,mv,B)
#' summary(boo2)
#' 
##
summary.boodd <- function(object,...) {
  message("kind = ",paste(attr(object,"kind"),collapse=" "))
  summary.default(object$s,...)
}
