% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackFuncBlock.R
\name{jackFuncBlock}
\alias{jackFuncBlock}
\title{Jackknife Variance Function Using Blocks of Fixed Length}
\usage{
jackFuncBlock(func, length.block = NULL, ...)
}
\arguments{
\item{func}{The function used to compute the statistic on each sample.}

\item{length.block}{An integer; the block length.
If not provided, a default value equals \eqn{\lfloor\left(length(X)\right)^{\frac{1}{3}}\rfloor}.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
Returns an object which is a function.
}
\description{
Creates a vector-valued function for computing both the statistic defined by \code{func}
and the estimated jackknife variance based on the blocks.
}
\details{
The \code{jackFuncBlock} function constructs a new function that,
when applied to a data sample,
calculates both the statistic specified by \code{func} and its associated
jackknife variance based on non-overlapping blocks of fixed length equals to \code{length.block}.

The block jackknife method is an extension of the jackknife
resampling technique, used to estimate
the bias and variance of a statistical estimate in the presence of dependent data.
}
\examples{
# Create a function to compute the empirical skewness
func <- function(x) { mean((x - mean(x))^3) / (mean((x - mean(x))^2)^(3/2)) }
x <- arima.sim(list(order = c(1, 0, 4), ar = 0.5, ma = c(0.7, 0.4, -0.3, -0.1)), n = 100)
# Create a function to compute the empirical skewness and its variance based on blocks of size 5
jfb <- jackFuncBlock(func, length.block = 5)
# Bootstrapping of the skewness and its variance allows to construct 
# bootstrap-t confidence intervals
boo2 <- blockboot(x, jfb, 299, length.block=7, method="circular")
confint(boo2, method="all")
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Carlstein, E. (1986). The use of subseries methods for estimating the variance
of a general statistic from a stationary time series. \emph{Annals of Statist.},
\bold{14}, 1171-1179.

Gray, H., Schucany, W. and Watkins, T. (1972).
\emph{The Generalized Jackknife Statistics}.
Marcel Dekker, New York.

Quenouille, M.H. (1949). Approximate tests of correlation in time-series.
\emph{J. Roy. Statist. Soc., Ser. B}, \bold{11}, 68-84.
}
\seealso{
\code{\link{jackVar}},
\code{\link{jackFunc}},
\code{\link{blockboot}},
\code{\link{jackVarBlock}},
\code{\link{jackFuncRegen}}.
}
\keyword{"Statistical}
\keyword{Blocks}
\keyword{Jackknife}
\keyword{Resampling}
\keyword{analysis"}
