% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackVarField.R
\name{jackVarField}
\alias{jackVarField}
\title{Jackknife Variance for Random Fields Based on Blocks}
\usage{
jackVarField(arr, func, length.block, ...)
}
\arguments{
\item{arr}{A multidimensional real-valued array; it represents a random field on a grid of
dimension equal to dimension of the \code{arr}.}

\item{func}{The function applied to each bootstrap sample.}

\item{length.block}{An integer or vector of integers; it specified the block lengths for blocks. If a
scalar is provided, the same block length is used for all dimensions.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
Returns a scalar or a covariance matrix, depending on whether the function \code{func}
is univariate or multivariate. For a function returning a vector of length \emph{p},
the output will be a covariance matrix of size \emph{p x p}.
}
\description{
Estimates the variance of a statistic applied to random fields
using non-overlapping multidimensional blocks.
}
\details{
The \code{\link{jackVarField}} function computes the jackknife variance
estimator for random fields. It involves dividing the array into non-overlapping blocks
of size specified by \code{length.block} and applying the function \code{func},
having output size equal to \emph{p}, to
the data with each block removed in turn. Finally, an empirical
variance of the obtained values is computed.
This method is particularly useful for data with spatial or multidimensional
structure.
}
\examples{
arr <- array(rnorm(1000), dim = c(10, 10, 10))
func <- function(x) { mean(x) }
length.block <- c(2, 2, 2)
result <- jackVarField(arr, func, length.block) 
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Carlstein, E. (1986). The use of subseries methods for estimating the variance
of a general statistic from a stationary time series. \emph{Annals of Statist.},
\bold{14}, 1171-1179.

Gray, H., Schucany, W. and Watkins, T. (1972).
\emph{The Generalized Jackknife Statistics}.
Marcel Dekker, New York.

Quenouille, M.H. (1949). Approximate tests of correlation in time-series.
\emph{J. Roy. Statist. Soc., Ser. B}, \bold{11}, 68-84.
}
\seealso{
\code{\link{jackVar}},
\code{\link{jackFunc}},
\code{\link{blockboot}},
\code{\link{jackVarBlock}},
\code{\link{jackFuncRegen}}.
}
\keyword{"Multidimensional}
\keyword{"Statistical}
\keyword{Blocks"}
\keyword{Jackknife}
\keyword{Resampling}
\keyword{analysis"}
