% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackVarRegen.smallEnsemblle.R
\name{jackVarRegen.smallEnsemble}
\alias{jackVarRegen.smallEnsemble}
\title{Jackknife Variance Estimation for General Harris Markov Chains}
\usage{
jackVarRegen.smallEnsemble(x, func, small, ...)
}
\arguments{
\item{x}{A vector or matrix representing the data from a general Harris Markov
chain.}

\item{func}{The function to apply to each sample.}

\item{small}{An object of class \code{\link{smallEnsemble}}. It can be
created optimally using \code{\link{findBestEpsilon}}.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
Returns a scalar or a covariance matrix, depending on whether the function \code{func}
is univariate or multivariate. For a function returning a vector of length
\emph{p}, the output will be a covariance matrix of size \emph{p x p}.
}
\description{
Estimates the jackknife variance of a function applied to
general Harris Markov chains using a regenerative approach and a
\code{smallEnsemble} object.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{The function uses a regenerative approach to estimate the 
}\if{html}{\out{</div>}}

jackknife variance for functions applied to general Harris Markov chains.
It relies on a \code{smallEnsemble}  object to define the regenerative structure
of the data. It segments the chain using an estimated Nummelin splitting trick
to create almost independent blocks. The function \code{func}, having output size equal to \emph{p},
is applied to the data with each approximate regenerative block removed
in turn to finally compute an empirical
variance of the obtained values.
}
\examples{
\donttest{
B=10
bb=0*(1:B)
cc=0*(1:B)
dd=0*(1:B)
for (i in 1:B) {
  ts=arima.sim(list(ar=0.4),200)
   vv=function(ts){as.numeric(var(ts))}
   bb[i]=mean(ts)
   cc[i]=jackVarRegen.smallEnsemble(ts,mean, small= findBestEpsilon(ts))}
var(bb)  
mean(cc) 
# Monte Carlo simulations
mean(dd) 
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Quenouille, M.H. (1949). Approximate tests of correlation in time-series.
\emph{J. Roy. Statist. Soc., Ser. B}, \bold{11}, 68-84.
}
\seealso{
\code{\link{jackVar}},
\code{\link{jackFunc}},
\code{\link{regenboot}},
\code{\link{jackFuncRegen}},
\code{\link{jackFuncBlock}},
\code{\link{jackVarRegen}}.
}
\keyword{"Harris}
\keyword{"Regenerative}
\keyword{"Variance}
\keyword{Jackknife}
\keyword{Markov}
\keyword{chains"}
\keyword{estimation"}
\keyword{processes"}
