% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca.R
\name{ca_row_cos2}
\alias{ca_row_cos2}
\alias{ca_row_sup_cos2}
\title{Compute row squared cosines}
\usage{
ca_row_cos2(row_coords, X)

ca_row_sup_cos2(row_coords, X_sup, X)
}
\arguments{
\item{row_coords}{row coordinates}

\item{X}{Active standardized matrix}

\item{X_sup}{Supplementary standardized matrix}
}
\value{
A dataframe of row squared cosines.
}
\description{
Return row squared cosines for each correspondence component
}
\examples{
library(booklet)

X_scaled <- mtcars[, c(2, 8:11)] |>
  ca_standardize()

X_scaled |>
  ca_weighted_eigen() |>
  ca_row_coords() |>
  ca_row_cos2(X_scaled) |>
  head()
}
