% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facto_pca.R
\name{facto_pca}
\alias{facto_pca}
\title{Perform PCA with FactoMineR's style}
\usage{
facto_pca(
  X,
  ncp = 5,
  scale.unit = TRUE,
  ind_sup = NULL,
  quanti_sup = NULL,
  weighted_col = NULL
)
}
\arguments{
\item{X}{a data frame with n rows (individuals) and p columns (numeric variables)}

\item{ncp}{an integer, the number of components to keep (value set by default)}

\item{scale.unit}{a boolean, if TRUE (value set by default) then data are scaled to unit variance}

\item{ind_sup}{a vector indicating the indexes of the supplementary individuals}

\item{quanti_sup}{a vector indicating the indexes of the quantitative supplementary variables}

\item{weighted_col}{column weights}
}
\value{
A list containing results of FactoMineR's principal components analysis (PCA).
}
\description{
Return PCA results with FactoMineR's style
}
\examples{
library(booklet)

res <- facto_pca(iris[, -5], ncp = 2, ind_sup = 1, quanti_sup = 1)
}
