% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca_ind_cos2}
\alias{pca_ind_cos2}
\title{Compute individual squared cosines}
\usage{
pca_ind_cos2(ind_coords, weighted_col = rep(1, ncol(ind_coords)))
}
\arguments{
\item{ind_coords}{individual coordinates}

\item{weighted_col}{column weights}
}
\value{
A dataframe of individual squared cosines.
}
\description{
Return individual squared cosines for each principal component
}
\examples{
library(booklet)

iris[, -5] |>
  pca_standardize_norm() |>
  pca_weighted_eigen() |>
  pca_ind_coords() |>
  pca_ind_cos2() |>
  head()
}
