% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_standardize.R
\name{pca_standardize_norm}
\alias{pca_standardize_norm}
\alias{pca_standardize}
\title{Data standardization for PCA}
\usage{
pca_standardize_norm(X, center = TRUE, scale = TRUE)

pca_standardize(X, scale = TRUE, weighted_row = rep(1, nrow(X))/nrow(X))
}
\arguments{
\item{X}{matrix}

\item{center}{centering by the mean}

\item{scale}{scaling by the standard deviation}

\item{weighted_row}{row weights}
}
\value{
A dataframe of the same size as \code{X}.
}
\description{
Perform data standardization for multivariate exploratory data analysis.
}
\details{
Standardization depends on what you need to perform factor analysis. Two
methods are implemented:
\itemize{
\item \code{standardize}: standardization is performed by centering the
data matrix and dividing by the square root of the sum of squares of the
weights. This is the same method used in \code{FactoMineR::PCA()}.
\item \code{standardize_norm}: standardization is performed by centering and scaling
the data matrix. (X - µ) / S, where µ is the mean and S is the standard deviation.
}
}
\examples{
library(booklet)

iris[, -5] |>
  pca_standardize_norm() |>
  head()
}
