#' Taiwanese banks (in 2010)
#'
#' @description The dataset consists of 31 banks operating in Taiwan.
#'
#' @usage data(banks)
#'
#' @format \code{banks} is a dataframe with 31 banks (rows) and 6 variables
#' (outputs) named \code{Financial.funds} (deposits and borrowed funds in
#' millions of TWD), \code{Labor} (number of employees),
#' \code{Physical.capital} (net amount of fixed assets in millions of TWD),
#' \code{Finalcial.investments} (financial assets, securities, and equity
#' investments in millions of TWD), \code{Loans} (loans and discounts in millions
#' of TWD) and \code{Revenue} (interests from financial investments and loans).
#'
#' @references Juo, J. C., Fu, T. T., Yu, M. M., & Lin, Y. H. (2015).
#' Profit-oriented productivity change. Omega, 57, 176-187.
#'
#' @source The dataset has been extracted from the “Condition and
#' Performance of Domestic Banks” published by the Central Bank of China
#' (Taiwan) and the Taiwan Economic Journal (TEJ) for the year 2010.
#' The “Condition and Performance of Domestic Banks” was downloaded from
#' http://www.cbc.gov.tw/ct.asp?xItem=1062&ctNode=535&mp=2
"banks"
