% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForwardAlgorithm.R
\name{AddBF}
\alias{AddBF}
\title{Add a new pair of Basis Functions}
\usage{
AddBF(data, x, y, ForwardModel, knots_list, Kp, minspan, Le, linpreds, err_min)
}
\arguments{
\item{data}{data \code{data.frame} or \code{matrix} containing the variables
in the model.}

\item{x}{Column input indexes in \code{data}.}

\item{y}{Column output indexes in \code{data}.}

\item{ForwardModel}{\code{list} containing the set of basis functions and the
B matrix.}

\item{knots_list}{\code{list} containing the set of selected knots.}

\item{Kp}{Maximum degree of interaction allowed.}

\item{minspan}{\code{integer}. Minimum number of observations between knots.
When \code{minspan = 0}, it is calculated as in Friedman's MARS paper section
3.8 with alpha = 0.05.}

\item{Le}{\code{integer} Minimum number of observations before the first and
after the final knot.}

\item{linpreds}{\code{logical}. If \code{TRUE}, predictors can enter linearly}

\item{err_min}{Minimum error in the split.}
}
\value{
A \code{list} containing the matrix of basis functions (\code{B}), a
\code{list} of basis functions (\code{BF}), a \code{list} of selected knots
(\code{knots_list}) and the minimum error (\code{err_min}).
}
\description{
This function adds the best pair of basis functions to the model
}
