% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kolmogorov_smirnov_distribution.R
\name{kolmogorov_smirnov_distribution}
\alias{kolmogorov_smirnov_distribution}
\alias{kolmogorov_smirnov_pdf}
\alias{kolmogorov_smirnov_lpdf}
\alias{kolmogorov_smirnov_cdf}
\alias{kolmogorov_smirnov_lcdf}
\alias{kolmogorov_smirnov_quantile}
\title{Kolmogorov-Smirnov Distribution Functions}
\usage{
kolmogorov_smirnov_distribution(n)

kolmogorov_smirnov_pdf(x, n)

kolmogorov_smirnov_lpdf(x, n)

kolmogorov_smirnov_cdf(x, n)

kolmogorov_smirnov_lcdf(x, n)

kolmogorov_smirnov_quantile(p, n)
}
\arguments{
\item{n}{sample size (n > 0)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Kolmogorov-Smirnov distribution.
}
\examples{
# Kolmogorov-Smirnov distribution with sample size n = 10
dist <- kolmogorov_smirnov_distribution(10)
# Apply generic functions
cdf(dist, 2)
logcdf(dist, 2)
pdf(dist, 2)
logpdf(dist, 2)
hazard(dist, 2)
chf(dist, 2)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
kolmogorov_smirnov_pdf(0.5, 10)
kolmogorov_smirnov_lpdf(0.5, 10)
kolmogorov_smirnov_cdf(0.5, 10)
kolmogorov_smirnov_lcdf(0.5, 10)
kolmogorov_smirnov_quantile(0.5, 10)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/kolmogorov_smirnov_dist.html}{Boost Documentation} for more details on the mathematical background.
}
