% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomials.R
\name{laguerre_polynomials}
\alias{laguerre_polynomials}
\alias{laguerre}
\alias{laguerre_m}
\alias{laguerre_next}
\alias{laguerre_next_m}
\title{Laguerre Polynomials and Related Functions}
\usage{
laguerre(n, x)

laguerre_m(n, m, x)

laguerre_next(n, x, Ln, Lnm1)

laguerre_next_m(n, m, x, Ln, Lnm1)
}
\arguments{
\item{n}{Degree of the polynomial}

\item{x}{Argument of the polynomial}

\item{m}{Order of the polynomial (for Laguerre polynomials of the first kind)}

\item{Ln}{Value of the Laguerre polynomial \eqn{(L_n(x))}}

\item{Lnm1}{Value of the Laguerre polynomial \eqn{(L_{n-1}(x))}}
}
\value{
A single numeric value with the computed Laguerre polynomial, its derivative, or related functions.
}
\description{
Functions to compute Laguerre polynomials of the first kind.
}
\examples{
# Laguerre polynomial of the first kind L_2(0.5)
laguerre(2, 0.5)
# Laguerre polynomial of the first kind with order 1 L_2^1(0.5)
laguerre_m(2, 1, 0.5)
# Next Laguerre polynomial of the first kind L_3(0.5) using L_2(0.5) and L_1(0.5)
laguerre_next(2, 0.5, laguerre(2, 0.5), laguerre(1, 0.5))
# Next Laguerre polynomial of the first kind with order 1 L_3^1(0.5) using L_2^1(0.5) and L_1^1(0.5)
laguerre_next_m(2, 1, 0.5, laguerre_m(2, 1, 0.5), laguerre_m(1, 1, 0.5))
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/sf_poly/laguerre.html}{Boost Documentation} for more details on the mathematical background.
}
