% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapairy_distribution.R
\name{mapairy_distribution}
\alias{mapairy_distribution}
\alias{mapairy_pdf}
\alias{mapairy_lpdf}
\alias{mapairy_cdf}
\alias{mapairy_lcdf}
\alias{mapairy_quantile}
\title{Map-Airy Distribution Functions}
\usage{
mapairy_distribution(location = 0, scale = 1)

mapairy_pdf(x, location = 0, scale = 1)

mapairy_lpdf(x, location = 0, scale = 1)

mapairy_cdf(x, location = 0, scale = 1)

mapairy_lcdf(x, location = 0, scale = 1)

mapairy_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Map-Airy distribution.
}
\examples{
# Map-Airy distribution with location 0 and scale 1
dist <- mapairy_distribution(0, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)

# Convenience functions
mapairy_pdf(3)
mapairy_lpdf(3)
mapairy_cdf(3)
mapairy_lcdf(3)
mapairy_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/mapairy_dist.html}{Boost Documentation} for more details on the mathematical background.
}
